/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.routes;

import io.avaje.jex.Context;
import io.avaje.jex.ExchangeHandler;
import io.avaje.jex.routes.PathParser;
import io.avaje.jex.routes.SpiRoutes;
import io.avaje.jex.security.Role;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

final class RouteEntry
implements SpiRoutes.Entry {
    private final AtomicLong active = new AtomicLong();
    private final PathParser path;
    private final ExchangeHandler handler;
    private final Set<Role> roles;

    RouteEntry(PathParser path, ExchangeHandler handler, Set<Role> roles) {
        this.path = path;
        this.handler = handler;
        this.roles = roles;
    }

    @Override
    public void inc() {
        this.active.incrementAndGet();
    }

    @Override
    public void dec() {
        this.active.decrementAndGet();
    }

    @Override
    public long activeRequests() {
        return this.active.get();
    }

    @Override
    public boolean matches(String requestUri) {
        return this.path.matches(requestUri);
    }

    @Override
    public void handle(Context ctx) throws IOException {
        this.handler.handle(ctx);
    }

    @Override
    public Map<String, String> pathParams(String uri) {
        return this.path.extractPathParams(uri);
    }

    @Override
    public String matchPath() {
        return this.path.raw();
    }

    @Override
    public int segmentCount() {
        return this.path.segmentCount();
    }

    @Override
    public boolean multiSlash() {
        return this.path.multiSlash();
    }

    @Override
    public boolean literal() {
        return this.path.literal();
    }

    @Override
    public Set<Role> roles() {
        return this.roles;
    }
}

