/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.compression;

import io.avaje.jex.compression.Compressor;
import io.avaje.jex.compression.GzipCompressor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CompressionConfig {
    private static final int HTTP_PACKET_SIZE = 1500;
    private static final Set<String> excludedMimeTypes = Set.of("application/compress", "application/zip", "application/gzip", "application/bzip2", "application/brotli", "application/x-xz", "application/x-rar-compressed");
    private boolean enabled = true;
    private int minSizeForCompression = 1500;
    private final Map<String, Compressor> compressors = new HashMap<String, GzipCompressor>(Map.of("gzip", new GzipCompressor()));
    private final Set<String> allowedExcludedTypes = Set.of("image/svg+xml");

    public void gzipCompressionLevel(int level) {
        this.compressors.put("gzip", new GzipCompressor(level));
    }

    public void disableCompression() {
        this.enabled = false;
        this.compressors.clear();
    }

    public int minSizeForCompression() {
        return this.minSizeForCompression;
    }

    public CompressionConfig minSizeForCompression(int minSizeForCompression) {
        this.minSizeForCompression = minSizeForCompression;
        if (minSizeForCompression < 1500) {
            throw new IllegalArgumentException("Compression should only happen on payloads bigger than an http packect");
        }
        return this;
    }

    public boolean compressionEnabled() {
        return this.enabled;
    }

    public boolean allowsForCompression(String contentType) {
        return contentType == null || this.allowedExcludedTypes.contains(contentType) || !excludedMimeTypes.contains(contentType) && !contentType.startsWith("image/") && !contentType.startsWith("audio/") && !contentType.startsWith("video/");
    }

    Compressor forType(String type) {
        return this.compressors.get(type.toLowerCase());
    }
}

