/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.jex.ClassResourceLoader;
import io.avaje.jex.Context;
import io.avaje.jex.DefaultResourceLoader;
import io.avaje.jex.ExchangeHandler;
import io.avaje.jex.ResourceLocation;
import io.avaje.jex.StaticClassResourceHandler;
import io.avaje.jex.StaticContentConfig;
import io.avaje.jex.StaticFileHandler;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

final class StaticResourceHandlerBuilder
implements StaticContentConfig {
    private static final String FAILED_TO_LOCATE_FILE = "Failed to locate file: ";
    private static final String DIRECTORY_INDEX_FAILURE = "Failed to locate Directory Index Resource: ";
    private static final Predicate<Context> NO_OP_PREDICATE = ctx -> false;
    private static final ClassResourceLoader DEFAULT_LOADER = new DefaultResourceLoader();
    private String path = "/";
    private String root = "/public/";
    private String directoryIndex = null;
    private ClassResourceLoader resourceLoader = DEFAULT_LOADER;
    private final Map<String, String> mimeTypes = new HashMap<String, String>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private Predicate<Context> skipFilePredicate = NO_OP_PREDICATE;
    private ResourceLocation location = ResourceLocation.CLASS_PATH;

    private StaticResourceHandlerBuilder() {
    }

    static StaticResourceHandlerBuilder builder() {
        return new StaticResourceHandlerBuilder();
    }

    @Override
    public ExchangeHandler createHandler() {
        this.path = Objects.requireNonNull(this.path).transform(this::prependSlash).transform(s -> s.endsWith("/*") ? s.substring(0, s.length() - 2) : s);
        boolean isClasspath = this.location == ResourceLocation.CLASS_PATH;
        String string = this.root = isClasspath ? this.root.transform(this::prependSlash) : this.root;
        if (isClasspath && "/".equals(this.root)) {
            throw new IllegalArgumentException("Cannot serve full classpath, please configure a classpath prefix");
        }
        if (this.root.endsWith("/") && this.directoryIndex == null) {
            throw new IllegalArgumentException("Directory Index file is required when serving directories");
        }
        if (this.location == ResourceLocation.FILE) {
            return this.fileLoader(File::new);
        }
        return this.classPathHandler();
    }

    @Override
    public StaticResourceHandlerBuilder httpPath(String path) {
        this.path = path.endsWith("/") ? path + "*" : path;
        return this;
    }

    @Override
    public String httpPath() {
        return this.path;
    }

    @Override
    public StaticResourceHandlerBuilder resource(String directory) {
        this.root = directory;
        return this;
    }

    @Override
    public StaticResourceHandlerBuilder directoryIndex(String directoryIndex) {
        this.directoryIndex = directoryIndex;
        return this;
    }

    @Override
    public StaticResourceHandlerBuilder resourceLoader(ClassResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        return this;
    }

    @Override
    public StaticResourceHandlerBuilder putMimeTypeMapping(String key, String value) {
        this.mimeTypes.put(key, value);
        return this;
    }

    @Override
    public StaticResourceHandlerBuilder putResponseHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public StaticResourceHandlerBuilder skipFilePredicate(Predicate<Context> skipFilePredicate) {
        this.skipFilePredicate = skipFilePredicate;
        return this;
    }

    @Override
    public StaticResourceHandlerBuilder location(ResourceLocation location) {
        this.location = location;
        return this;
    }

    private String prependSlash(String s) {
        return s.startsWith("/") ? s : "/" + s;
    }

    private String appendSlash(String s) {
        return s.endsWith("/") ? s : s + "/";
    }

    private ExchangeHandler fileLoader(Function<String, File> fileLoader) {
        String fsRoot;
        File dirIndex = null;
        File singleFile = null;
        if (this.directoryIndex != null) {
            try {
                dirIndex = fileLoader.apply(this.root.transform(this::appendSlash) + this.directoryIndex).getCanonicalFile();
                fsRoot = dirIndex.getParentFile().getPath();
            }
            catch (Exception e) {
                throw new IllegalStateException(DIRECTORY_INDEX_FAILURE + this.root.transform(this::appendSlash) + this.directoryIndex, e);
            }
        }
        try {
            singleFile = fileLoader.apply(this.root).getCanonicalFile();
            fsRoot = singleFile.getParentFile().getPath();
        }
        catch (Exception e) {
            throw new IllegalStateException(FAILED_TO_LOCATE_FILE + this.root, e);
        }
        return new StaticFileHandler(this.path, fsRoot, this.mimeTypes, this.headers, this.skipFilePredicate, dirIndex, singleFile);
    }

    private ExchangeHandler classPathHandler() {
        URL dirIndex = null;
        URL singleFile = null;
        if (this.directoryIndex != null) {
            dirIndex = this.resourceLoader.loadResource(this.root.transform(this::appendSlash) + this.directoryIndex);
        } else {
            singleFile = this.resourceLoader.loadResource(this.root);
        }
        return new StaticClassResourceHandler(this.path, this.root, this.mimeTypes, this.headers, this.skipFilePredicate, this.resourceLoader, dirIndex, singleFile);
    }
}

