/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import com.sun.net.httpserver.HttpExchange;
import io.avaje.jex.AbstractStaticHandler;
import io.avaje.jex.ClassResourceLoader;
import io.avaje.jex.Context;
import io.avaje.jex.ExchangeHandler;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.Predicate;

final class StaticClassResourceHandler
extends AbstractStaticHandler
implements ExchangeHandler {
    private final URL indexFile;
    private final URL singleFile;
    private final ClassResourceLoader resourceLoader;

    StaticClassResourceHandler(String urlPrefix, String filesystemRoot, Map<String, String> mimeTypes, Map<String, String> headers, Predicate<Context> skipFilePredicate, ClassResourceLoader resourceLoader, URL indexFile, URL singleFile) {
        super(urlPrefix, filesystemRoot, mimeTypes, headers, skipFilePredicate);
        this.resourceLoader = resourceLoader;
        this.indexFile = indexFile;
        this.singleFile = singleFile;
    }

    @Override
    public void handle(Context ctx) {
        String wholeUrlPath;
        if (this.singleFile != null) {
            this.sendURL(ctx, this.singleFile.getPath(), this.singleFile);
            return;
        }
        HttpExchange jdkExchange = ctx.exchange();
        if (this.skipFilePredicate.test(ctx)) {
            this.throw404(jdkExchange);
        }
        if ((wholeUrlPath = jdkExchange.getRequestURI().getPath()).endsWith("/") || wholeUrlPath.equals(this.urlPrefix)) {
            this.sendURL(ctx, this.indexFile.getPath(), this.indexFile);
            return;
        }
        String urlPath = wholeUrlPath.substring(this.urlPrefix.length());
        String normalizedPath = Paths.get(this.filesystemRoot, urlPath).normalize().toString().replace("\\", "/");
        if (!normalizedPath.startsWith(this.filesystemRoot)) {
            this.reportPathTraversal();
        }
        try (InputStream fis = this.resourceLoader.loadResourceAsStream(normalizedPath);){
            ctx.header("Content-Type", this.lookupMime(normalizedPath));
            ctx.headers(this.headers);
            ctx.write(fis);
        }
        catch (Exception e) {
            this.throw404(ctx.exchange());
        }
    }

    private void sendURL(Context ctx, String urlPath, URL path) {
        try (InputStream fis = path.openStream();){
            ctx.header("Content-Type", this.lookupMime(urlPath));
            ctx.headers(this.headers);
            ctx.write(fis);
        }
        catch (Exception e) {
            this.throw404(ctx.exchange());
        }
    }
}

