/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.jex.JexConfig;
import io.avaje.jex.compression.CompressionConfig;
import io.avaje.jex.spi.JsonService;
import io.avaje.jex.spi.TemplateRender;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;

final class DJexConfig
implements JexConfig {
    private int port = 8080;
    private String host;
    private String contextPath = "/";
    private boolean health = true;
    private boolean ignoreTrailingSlashes = true;
    private Executor executor;
    private JsonService jsonService;
    private final Map<String, TemplateRender> renderers = new HashMap<String, TemplateRender>();
    private SSLContext sslContext;
    private boolean useJexSpi = true;
    private final CompressionConfig compression = new CompressionConfig();

    DJexConfig() {
    }

    @Override
    public JexConfig port(int port) {
        this.port = port;
        return this;
    }

    @Override
    public JexConfig host(String host) {
        this.host = host;
        return this;
    }

    @Override
    public JexConfig contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    @Override
    public JexConfig health(boolean health) {
        this.health = health;
        return this;
    }

    @Override
    public JexConfig ignoreTrailingSlashes(boolean ignoreTrailingSlashes) {
        this.ignoreTrailingSlashes = ignoreTrailingSlashes;
        return this;
    }

    @Override
    public JexConfig jsonService(JsonService jsonService) {
        this.jsonService = jsonService;
        return this;
    }

    @Override
    public JexConfig renderer(String extension, TemplateRender renderer) {
        this.renderers.put(extension, renderer);
        return this;
    }

    @Override
    public Executor executor() {
        if (this.executor == null) {
            this.executor = Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("avaje-jex-http-", 0L).factory());
        }
        return this.executor;
    }

    @Override
    public JexConfig executor(Executor factory) {
        this.executor = factory;
        return this;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public String contextPath() {
        return this.contextPath;
    }

    @Override
    public boolean health() {
        return this.health;
    }

    @Override
    public boolean ignoreTrailingSlashes() {
        return this.ignoreTrailingSlashes;
    }

    @Override
    public JsonService jsonService() {
        return this.jsonService;
    }

    @Override
    public Map<String, TemplateRender> renderers() {
        return this.renderers;
    }

    @Override
    public SSLContext sslContext() {
        return this.sslContext;
    }

    @Override
    public JexConfig sslContext(SSLContext ssl) {
        this.sslContext = ssl;
        return this;
    }

    @Override
    public JexConfig compression(Consumer<CompressionConfig> consumer) {
        consumer.accept(this.compression);
        return this;
    }

    @Override
    public CompressionConfig compression() {
        return this.compression;
    }

    @Override
    public DJexConfig disableSpiPlugins() {
        this.useJexSpi = false;
        return this;
    }

    boolean useSpiPlugins() {
        return this.useJexSpi;
    }
}

