/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import com.sun.net.httpserver.spi.HttpServerProvider;
import io.avaje.jex.AppLifecycle;
import io.avaje.jex.Jex;
import io.avaje.jex.JexConfig;
import io.avaje.jex.core.CoreServiceLoader;
import io.avaje.jex.core.HealthPlugin;
import io.avaje.jex.core.JdkJexServer;
import io.avaje.jex.core.RoutingHandler;
import io.avaje.jex.core.ServiceManager;
import io.avaje.jex.routes.RoutesBuilder;
import io.avaje.jex.routes.SpiRoutes;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class BootstrapServer {
    private static final System.Logger log = System.getLogger("io.avaje.jex");

    private BootstrapServer() {
    }

    public static Jex.Server start(Jex jex) {
        JexConfig config = jex.config();
        if (config.health()) {
            jex.plugin(new HealthPlugin());
        }
        if (config.useSpiPlugins()) {
            CoreServiceLoader.plugins().forEach(p -> p.apply(jex));
        }
        SpiRoutes routes = new RoutesBuilder(jex.routing(), config).build();
        return BootstrapServer.start(jex, routes);
    }

    static Jex.Server start(Jex jex, SpiRoutes routes) {
        try {
            HttpServer server;
            JexConfig config = jex.config();
            InetSocketAddress socketAddress = BootstrapServer.createSocketAddress(config);
            HttpsConfigurator https = config.httpsConfig();
            HttpServerProvider provider = config.serverProvider();
            if (https != null) {
                HttpsServer httpsServer = provider.createHttpsServer(socketAddress, config.socketBacklog());
                httpsServer.setHttpsConfigurator(https);
                server = httpsServer;
            } else {
                server = provider.createHttpServer(socketAddress, config.socketBacklog());
            }
            String scheme = config.scheme();
            String contextPath = config.contextPath();
            ServiceManager serviceManager = ServiceManager.create(jex);
            RoutingHandler handler = new RoutingHandler(routes, serviceManager);
            Class<?> serverClass = server.getClass();
            if (!serverClass.getName().contains("jetty")) {
                server.setExecutor(config.executor());
            }
            server.createContext(contextPath, handler);
            server.start();
            jex.lifecycle().status(AppLifecycle.Status.STARTED);
            log.log(System.Logger.Level.INFO, "Avaje Jex started {0} on port {1}://{2}", serverClass, scheme, socketAddress);
            log.log(System.Logger.Level.DEBUG, routes);
            return new JdkJexServer(server, jex.lifecycle(), handler);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static InetSocketAddress createSocketAddress(JexConfig config) throws UnknownHostException {
        InetAddress inetAddress = config.host() == null ? null : InetAddress.getByName(config.host());
        return new InetSocketAddress(inetAddress, config.port());
    }
}

