/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.jex.ExchangeHandler;
import io.avaje.jex.HttpFilter;
import io.avaje.jex.core.JdkContext;
import io.avaje.jex.core.Mode;
import io.avaje.jex.core.ServiceManager;
import java.util.Iterator;

final class BaseFilterChain
implements HttpFilter.FilterChain {
    private final Iterator<HttpFilter> filters;
    private final ExchangeHandler handler;
    private final JdkContext ctx;
    private final ServiceManager mgr;

    BaseFilterChain(Iterator<HttpFilter> filters, ExchangeHandler handler, JdkContext ctx, ServiceManager mgr) {
        this.filters = filters;
        this.handler = handler;
        this.ctx = ctx;
        this.mgr = mgr;
    }

    @Override
    public void proceed() {
        if (this.filters.hasNext()) {
            this.filters.next().filter(this.ctx, this);
        } else {
            try {
                if (!this.ctx.responseSent()) {
                    this.handler.handle(this.ctx);
                }
            }
            catch (Exception t) {
                this.mgr.handleException(this.ctx, t);
            }
        }
        this.ctx.setMode(Mode.AFTER);
    }
}

