/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.jex.AppLifecycle;
import io.avaje.jex.Context;
import io.avaje.jex.Jex;
import io.avaje.jex.security.Role;
import io.avaje.jex.spi.JexPlugin;

final class HealthPlugin
implements JexPlugin {
    private AppLifecycle lifecycle;

    HealthPlugin() {
    }

    @Override
    public void apply(Jex jex) {
        this.lifecycle = jex.lifecycle();
        jex.routing().get("/health/liveness", this::liveness, new Role[0]);
        jex.routing().get("/health/readiness", this::readiness, new Role[0]);
    }

    private void readiness(Context context) {
        if (this.lifecycle.isReady()) {
            context.text("ok");
        } else {
            context.status(500).text("not-ready");
        }
    }

    private void liveness(Context context) {
        if (this.lifecycle.isAlive()) {
            context.text("ok");
        } else {
            context.status(500).text("not-alive");
        }
    }
}

