/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.jdk;

import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpExchange;
import io.avaje.jex.ExchangeHandler;
import io.avaje.jex.Routing;
import io.avaje.jex.compression.CompressionConfig;
import io.avaje.jex.http.NotFoundException;
import io.avaje.jex.jdk.CtxServiceManager;
import io.avaje.jex.jdk.JdkContext;
import io.avaje.jex.routes.SpiRoutes;
import io.avaje.jex.spi.SpiContext;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

final class RoutingFilter
extends Filter {
    private final SpiRoutes routes;
    private final CtxServiceManager mgr;
    private final CompressionConfig compressionConfig;

    RoutingFilter(SpiRoutes routes, CtxServiceManager mgr, CompressionConfig compressionConfig) {
        this.mgr = mgr;
        this.routes = routes;
        this.compressionConfig = compressionConfig;
    }

    void waitForIdle(long maxSeconds) {
        this.routes.waitForIdle(maxSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(HttpExchange exchange, Filter.Chain chain) {
        String uri = exchange.getRequestURI().getPath();
        Routing.Type routeType = this.mgr.lookupRoutingType(exchange.getRequestMethod());
        SpiRoutes.Entry route = this.routes.match(routeType, uri);
        if (route == null) {
            JdkContext ctx = new JdkContext(this.mgr, this.compressionConfig, exchange, uri, Set.of());
            this.routes.inc();
            try {
                this.processNoRoute(ctx, uri, routeType);
                exchange.setAttribute("JdkContext", ctx);
                chain.doFilter(exchange);
                this.handleNoResponse(exchange);
            }
            catch (Exception e) {
                this.handleException(ctx, e);
            }
            finally {
                this.routes.dec();
                exchange.close();
            }
        } else {
            route.inc();
            try {
                Map<String, String> params = route.pathParams(uri);
                JdkContext ctx = new JdkContext(this.mgr, this.compressionConfig, exchange, route.matchPath(), params, route.roles());
                try {
                    ctx.setMode(Routing.Type.FILTER);
                    exchange.setAttribute("JdkContext", ctx);
                    ExchangeHandler handlerConsumer = route::handle;
                    exchange.setAttribute("SpiRoutes.Entry.Handler", handlerConsumer);
                    chain.doFilter(exchange);
                    this.handleNoResponse(exchange);
                }
                catch (Exception e) {
                    this.handleException(ctx, e);
                }
            }
            finally {
                route.dec();
                exchange.close();
            }
        }
    }

    private void handleNoResponse(HttpExchange exchange) throws IOException {
        if (exchange.getResponseCode() == -1) {
            exchange.sendResponseHeaders(204, -1L);
        }
    }

    private void handleException(SpiContext ctx, Exception e) {
        this.mgr.handleException(ctx, e);
    }

    private void processNoRoute(JdkContext ctx, String uri, Routing.Type routeType) {
        if (routeType == Routing.Type.HEAD && this.hasGetHandler(uri)) {
            ctx.status(200);
            return;
        }
        throw new NotFoundException("uri: " + uri);
    }

    private boolean hasGetHandler(String uri) {
        return this.routes.match(Routing.Type.GET, uri) != null;
    }

    @Override
    public String description() {
        return "Routing Filter";
    }
}

