/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.jdk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class CookieParser {
    private static final String QUOTE = "\"";
    private static final char[] QUOTE_CHARS = "\"".toCharArray();
    private static final String RFC2965_VERSION = "$Version";
    private static final String RFC2965_PATH = "$Path";
    private static final String RFC2965_DOMAIN = "$Domain";
    private static final String RFC2965_PORT = "$Port";

    private CookieParser() {
    }

    static Map<String, String> parse(String rawHeader) {
        if (rawHeader == null) {
            return Collections.emptyMap();
        }
        if ((rawHeader = rawHeader.trim()).isEmpty()) {
            return Collections.emptyMap();
        }
        boolean isRfc2965 = false;
        if (rawHeader.regionMatches(true, 0, RFC2965_VERSION, 0, RFC2965_VERSION.length())) {
            isRfc2965 = true;
            int ind = rawHeader.indexOf(59);
            if (ind < 0) {
                return Collections.emptyMap();
            }
            rawHeader = rawHeader.substring(ind + 1);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String baseToken : CookieParser.tokenize(',', rawHeader)) {
            for (String token : CookieParser.tokenize(';', baseToken)) {
                String value;
                String name;
                int eqInd = token.indexOf(61);
                if (eqInd <= 0 || (name = token.substring(0, eqInd).trim()).isEmpty() || isRfc2965 && name.charAt(0) == '$' && CookieParser.ignore(name) || (value = CookieParser.unwrap(token.substring(eqInd + 1).trim())).isEmpty()) continue;
                map.put(name, value);
            }
        }
        return map;
    }

    private static boolean ignore(String name) {
        return RFC2965_PATH.equalsIgnoreCase(name) || RFC2965_DOMAIN.equalsIgnoreCase(name) || RFC2965_PORT.equalsIgnoreCase(name) || RFC2965_VERSION.equalsIgnoreCase(name);
    }

    private static String unwrap(String value) {
        if (value.length() >= 2 && '\"' == value.charAt(0) && '\"' == value.charAt(value.length() - 1)) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    static List<String> tokenize(char separator, String text) {
        StringBuilder token = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        boolean quoted = false;
        char lastQuoteCharacter = ' ';
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (quoted) {
                if (ch == lastQuoteCharacter) {
                    quoted = false;
                }
                token.append(ch);
                continue;
            }
            if (ch == separator) {
                if (!token.isEmpty()) {
                    result.add(token.toString());
                }
                token.setLength(0);
                continue;
            }
            for (char quote : QUOTE_CHARS) {
                if (ch != quote) continue;
                quoted = true;
                lastQuoteCharacter = ch;
                break;
            }
            token.append(ch);
        }
        if (!token.isEmpty()) {
            result.add(token.toString());
        }
        return result;
    }
}

