/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.jex.ClassResourceLoader;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;

final class DefaultResourceLoader
implements ClassResourceLoader {
    private final Class<?> clazz;

    DefaultResourceLoader() {
        this.clazz = DefaultResourceLoader.class;
    }

    DefaultResourceLoader(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public URL loadResource(String resourcePath) {
        URL url = this.clazz.getResource(resourcePath);
        if (url == null) {
            url = Optional.ofNullable(ClassLoader.getSystemResource(resourcePath)).orElseGet(() -> Thread.currentThread().getContextClassLoader().getResource(resourcePath));
        }
        return Objects.requireNonNull(url, "Unable to locate resource: " + resourcePath);
    }

    @Override
    public InputStream loadResourceAsStream(String resourcePath) {
        InputStream url = this.clazz.getResourceAsStream(resourcePath);
        if (url == null) {
            url = Optional.ofNullable(ClassLoader.getSystemResourceAsStream(resourcePath)).orElseGet(() -> Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath));
        }
        return Objects.requireNonNull(url, "Unable to locate resource: " + resourcePath);
    }
}

