/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import com.sun.net.httpserver.HttpExchange;
import io.avaje.jex.DCookie;
import io.avaje.jex.security.BasicAuthCredentials;
import io.avaje.jex.security.Role;
import java.io.InputStream;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public interface Context {
    public String matchedPath();

    public Context attribute(String var1, Object var2);

    public <T> T attribute(String var1);

    public String cookie(String var1);

    public Map<String, String> cookieMap();

    public Context cookie(String var1, String var2);

    public Context cookie(String var1, String var2, int var3);

    public Context cookie(Cookie var1);

    public Context removeCookie(String var1);

    public Context removeCookie(String var1, String var2);

    public void redirect(String var1);

    public void redirect(String var1, int var2);

    public Set<Role> routeRoles();

    public byte[] bodyAsBytes();

    public InputStream bodyAsInputStream();

    public <T> T bodyAsClass(Class<T> var1);

    public String body();

    public long contentLength();

    public String contentType();

    public Context contentType(String var1);

    public Map<String, String> pathParamMap();

    public String pathParam(String var1);

    public String queryParam(String var1);

    default public String queryParam(String name, String defaultValue) {
        String val = this.queryParam(name);
        return val != null ? val : defaultValue;
    }

    public List<String> queryParams(String var1);

    public Map<String, String> queryParamMap();

    public String queryString();

    default public String formParam(String key) {
        return this.formParam(key, null);
    }

    default public String formParam(String key, String defaultValue) {
        List<String> values = this.formParamMap().get(key);
        return values == null || values.isEmpty() ? defaultValue : values.get(0);
    }

    default public List<String> formParams(String key) {
        List<String> values = this.formParamMap().get(key);
        return values != null ? values : Collections.emptyList();
    }

    public Map<String, List<String>> formParamMap();

    public HttpExchange exchange();

    public String scheme();

    public String url();

    default public String fullUrl() {
        String url = this.url();
        String qs = this.queryString();
        return qs == null ? url : url + "?" + qs;
    }

    public String contextPath();

    default public String userAgent() {
        return this.header("User-Agent");
    }

    public Context status(int var1);

    public int status();

    public Context text(String var1);

    public Context html(String var1);

    public Context json(Object var1);

    public <E> Context jsonStream(Stream<E> var1);

    public <E> Context jsonStream(Iterator<E> var1);

    public Context write(String var1);

    public Context write(byte[] var1);

    public Context write(InputStream var1);

    default public Context render(String name) {
        return this.render(name, Collections.emptyMap());
    }

    public Context render(String var1, Map<String, Object> var2);

    public Map<String, String> headerMap();

    public String header(String var1);

    public Context header(String var1, String var2);

    default public Context headers(Map<String, String> headers) {
        headers.forEach(this::header);
        return this;
    }

    public String responseHeader(String var1);

    public String host();

    public String ip();

    public String method();

    public String path();

    public int port();

    public String protocol();

    public BasicAuthCredentials basicAuthCredentials();

    public static interface Cookie {
        public static Cookie expired(String name) {
            return DCookie.expired(name);
        }

        public static Cookie of(String name, String value) {
            return DCookie.of(name, value);
        }

        public String name();

        public String value();

        public String domain();

        public Cookie domain(String var1);

        public Duration maxAge();

        public Cookie maxAge(Duration var1);

        public ZonedDateTime expires();

        public Cookie expires(ZonedDateTime var1);

        public String path();

        public Cookie path(String var1);

        public boolean secure();

        public Cookie secure(boolean var1);

        public boolean httpOnly();

        public Cookie httpOnly(boolean var1);

        public String toString();
    }
}

