/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import com.sun.net.httpserver.HttpExchange;
import io.avaje.jex.Context;
import io.avaje.jex.ExchangeHandler;
import io.avaje.jex.StaticClassResourceHandler;
import io.avaje.jex.StaticFileHandler;
import io.avaje.jex.http.BadRequestException;
import io.avaje.jex.http.NotFoundException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

abstract sealed class AbstractStaticHandler
implements ExchangeHandler
permits StaticFileHandler, StaticClassResourceHandler {
    protected final Map<String, String> mimeTypes;
    protected final String filesystemRoot;
    protected final String urlPrefix;
    protected final Predicate<Context> skipFilePredicate;
    protected final Map<String, String> headers;
    private static final FileNameMap MIME_MAP = URLConnection.getFileNameMap();

    protected AbstractStaticHandler(String urlPrefix, String filesystemRoot, Map<String, String> mimeTypes, Map<String, String> headers, Predicate<Context> skipFilePredicate) {
        this.filesystemRoot = filesystemRoot;
        this.urlPrefix = urlPrefix;
        this.skipFilePredicate = skipFilePredicate;
        this.headers = headers;
        this.mimeTypes = mimeTypes;
    }

    protected void throw404(HttpExchange jdkExchange) {
        throw new NotFoundException("File Not Found for request: " + String.valueOf(jdkExchange.getRequestURI()));
    }

    protected void reportPathTraversal() {
        throw new BadRequestException("Path traversal attempt detected");
    }

    protected String getExt(String path) {
        int slashIndex = path.lastIndexOf(47);
        String basename = slashIndex < 0 ? path : path.substring(slashIndex + 1);
        int dotIndex = basename.lastIndexOf(46);
        if (dotIndex >= 0) {
            return basename.substring(dotIndex + 1);
        }
        return "";
    }

    protected String lookupMime(String path) {
        String lower = path.toLowerCase();
        return Objects.requireNonNullElseGet(MIME_MAP.getContentTypeFor(path), () -> {
            String ext = this.getExt(lower);
            return this.mimeTypes.getOrDefault(ext, "application/octet-stream");
        });
    }
}

