/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.jex.AppLifecycle;
import io.avaje.jex.Context;
import io.avaje.jex.Jex;
import io.avaje.jex.Plugin;

public class HealthPlugin
implements Plugin {
    private AppLifecycle lifecycle;

    @Override
    public void apply(Jex jex) {
        this.lifecycle = jex.lifecycle();
        jex.routing().get("/health/liveness", this::liveness);
        jex.routing().get("/health/readiness", this::readiness);
    }

    private void readiness(Context context) {
        if (this.lifecycle.isReady()) {
            context.text("ok");
        } else {
            context.status(500).text("not-ready");
        }
    }

    private void liveness(Context context) {
        if (this.lifecycle.isAlive()) {
            context.text("ok");
        } else {
            context.status(500).text("not-alive");
        }
    }
}

