/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.jex.Handler;
import io.avaje.jex.Role;
import io.avaje.jex.Routing;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;

class DefaultRouting
implements Routing {
    private final List<Routing.Entry> handlers = new ArrayList<Routing.Entry>();
    private final Deque<String> pathDeque = new ArrayDeque<String>();
    private Entry lastEntry;

    DefaultRouting() {
    }

    @Override
    public List<Routing.Entry> all() {
        return this.handlers;
    }

    private String path(String path) {
        return String.join((CharSequence)"", this.pathDeque) + (String)(path.startsWith("/") || path.isEmpty() ? path : "/" + path);
    }

    private void addEndpoints(String path, Routing.Group group) {
        path = ((String)path).startsWith("/") ? path : "/" + (String)path;
        this.pathDeque.addLast((String)path);
        group.addGroup();
        this.pathDeque.removeLast();
    }

    @Override
    public Routing add(Routing.Service routes) {
        routes.add(this);
        return this;
    }

    @Override
    public Routing addAll(Collection<Routing.Service> routes) {
        for (Routing.Service route : routes) {
            route.add(this);
        }
        return this;
    }

    @Override
    public Routing path(String path, Routing.Group group) {
        this.addEndpoints(path, group);
        return this;
    }

    @Override
    public Routing withRoles(Set<Role> permittedRoles) {
        if (this.lastEntry == null) {
            throw new IllegalStateException("Must call withRoles() after adding a route");
        }
        this.lastEntry.withRoles(permittedRoles);
        return this;
    }

    @Override
    public Routing withRoles(Role ... permittedRoles) {
        return this.withRoles(Set.of(permittedRoles));
    }

    private void add(Routing.Type verb, String path, Handler handler) {
        this.lastEntry = new Entry(verb, this.path(path), handler);
        this.handlers.add(this.lastEntry);
    }

    private void addBefore(String path, Handler handler) {
        this.add(Routing.Type.BEFORE, this.path(path), handler);
    }

    private void addAfter(String path, Handler handler) {
        this.add(Routing.Type.AFTER, this.path(path), handler);
    }

    @Override
    public Routing get(String path, Handler handler) {
        this.add(Routing.Type.GET, path, handler);
        return this;
    }

    @Override
    public Routing get(Handler handler) {
        this.get("", handler);
        return this;
    }

    @Override
    public Routing post(String path, Handler handler) {
        this.add(Routing.Type.POST, path, handler);
        return this;
    }

    @Override
    public Routing post(Handler handler) {
        this.post("", handler);
        return this;
    }

    @Override
    public Routing put(String path, Handler handler) {
        this.add(Routing.Type.PUT, path, handler);
        return this;
    }

    @Override
    public Routing put(Handler handler) {
        this.put("", handler);
        return this;
    }

    @Override
    public Routing patch(String path, Handler handler) {
        this.add(Routing.Type.PATCH, path, handler);
        return this;
    }

    @Override
    public Routing patch(Handler handler) {
        this.patch("", handler);
        return this;
    }

    @Override
    public Routing delete(String path, Handler handler) {
        this.add(Routing.Type.DELETE, path, handler);
        return this;
    }

    @Override
    public Routing delete(Handler handler) {
        this.delete("", handler);
        return this;
    }

    @Override
    public Routing head(String path, Handler handler) {
        this.add(Routing.Type.HEAD, path, handler);
        return this;
    }

    @Override
    public Routing head(Handler handler) {
        this.head("", handler);
        return this;
    }

    @Override
    public Routing trace(String path, Handler handler) {
        this.add(Routing.Type.TRACE, path, handler);
        return this;
    }

    @Override
    public Routing trace(Handler handler) {
        this.trace("", handler);
        return this;
    }

    @Override
    public Routing before(String path, Handler handler) {
        this.addBefore(path, handler);
        return this;
    }

    @Override
    public Routing before(Handler handler) {
        this.before("/*", handler);
        return this;
    }

    @Override
    public Routing after(String path, Handler handler) {
        this.addAfter(path, handler);
        return this;
    }

    @Override
    public Routing after(Handler handler) {
        this.after("/*", handler);
        return this;
    }

    private static class Entry
    implements Routing.Entry {
        private final Routing.Type type;
        private final String path;
        private final Handler handler;
        private Set<Role> roles = Collections.emptySet();

        Entry(Routing.Type type, String path, Handler handler) {
            this.type = type;
            this.path = path;
            this.handler = handler;
        }

        void withRoles(Set<Role> roles) {
            this.roles = roles;
        }

        @Override
        public Routing.Type getType() {
            return this.type;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public Handler getHandler() {
            return this.handler;
        }

        @Override
        public Set<Role> getRoles() {
            return this.roles;
        }
    }
}

