/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.jex.AccessManager;
import io.avaje.jex.JexConfig;
import io.avaje.jex.TemplateRender;
import io.avaje.jex.UploadConfig;
import io.avaje.jex.spi.JsonService;
import java.util.HashMap;
import java.util.Map;

class DJexConfig
implements JexConfig {
    private int port = 7001;
    private String host;
    private String contextPath = "/";
    private boolean health = true;
    private boolean ignoreTrailingSlashes = true;
    private boolean virtualThreads;
    private boolean preCompressStaticFiles;
    private JsonService jsonService;
    private AccessManager accessManager;
    private UploadConfig multipartConfig;
    private int multipartFileThreshold = 8192;
    private final Map<String, TemplateRender> renderers = new HashMap<String, TemplateRender>();

    DJexConfig() {
    }

    @Override
    public JexConfig port(int port) {
        this.port = port;
        return this;
    }

    @Override
    public JexConfig host(String host) {
        this.host = host;
        return this;
    }

    @Override
    public JexConfig contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    @Override
    public JexConfig health(boolean health) {
        this.health = health;
        return this;
    }

    @Override
    public JexConfig ignoreTrailingSlashes(boolean ignoreTrailingSlashes) {
        this.ignoreTrailingSlashes = ignoreTrailingSlashes;
        return this;
    }

    @Override
    public JexConfig preCompressStaticFiles(boolean preCompressStaticFiles) {
        this.preCompressStaticFiles = preCompressStaticFiles;
        return this;
    }

    @Override
    public JexConfig jsonService(JsonService jsonService) {
        this.jsonService = jsonService;
        return this;
    }

    @Override
    public JexConfig accessManager(AccessManager accessManager) {
        this.accessManager = accessManager;
        return this;
    }

    @Override
    public JexConfig multipartConfig(UploadConfig multipartConfig) {
        this.multipartConfig = multipartConfig;
        return this;
    }

    @Override
    public JexConfig multipartFileThreshold(int multipartFileThreshold) {
        this.multipartFileThreshold = multipartFileThreshold;
        return this;
    }

    @Override
    public JexConfig renderer(String extension, TemplateRender renderer) {
        this.renderers.put(extension, renderer);
        return this;
    }

    @Override
    public boolean virtualThreads() {
        return this.virtualThreads;
    }

    @Override
    public JexConfig virtualThreads(boolean virtualThreads) {
        this.virtualThreads = virtualThreads;
        return this;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public String contextPath() {
        return this.contextPath;
    }

    @Override
    public boolean health() {
        return this.health;
    }

    @Override
    public boolean ignoreTrailingSlashes() {
        return this.ignoreTrailingSlashes;
    }

    @Override
    public boolean preCompressStaticFiles() {
        return this.preCompressStaticFiles;
    }

    @Override
    public JsonService jsonService() {
        return this.jsonService;
    }

    @Override
    public AccessManager accessManager() {
        return this.accessManager;
    }

    @Override
    public UploadConfig multipartConfig() {
        return this.multipartConfig;
    }

    @Override
    public int multipartFileThreshold() {
        return this.multipartFileThreshold;
    }

    @Override
    public Map<String, TemplateRender> renderers() {
        return this.renderers;
    }
}

