/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.config.Config;
import io.avaje.inject.BeanScope;
import io.avaje.jex.Jex;
import io.avaje.jex.JexConfig;

class BootJexState {
    private static State state;

    BootJexState() {
    }

    static void start() {
        state = new BootJexState().create();
    }

    static void stop() {
        state.stop();
    }

    static void restart() {
        state.restart();
    }

    State create() {
        BeanScope beanScope = BeanScope.builder().build();
        Jex jex = beanScope.getOptional(Jex.class).orElse(Jex.create());
        jex.configureWith(beanScope);
        JexConfig config = jex.config();
        int port = config.port();
        if (port == 7001) {
            config.port(Config.getInt((String)"jex.port", (int)port));
        }
        jex.lifecycle().onShutdown(() -> ((BeanScope)beanScope).close());
        return new State(jex.start(), beanScope);
    }

    private static class State {
        private final Jex.Server server;
        private final BeanScope beanScope;

        State(Jex.Server server, BeanScope beanScope) {
            this.server = server;
            this.beanScope = beanScope;
        }

        void stop() {
            this.server.shutdown();
        }

        public void restart() {
            this.server.restart();
        }
    }
}

