/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.jex.UploadedFile;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public interface Context {
    public String matchedPath();

    public Context attribute(String var1, Object var2);

    public <T> T attribute(String var1);

    public String cookie(String var1);

    public Map<String, String> cookieMap();

    public Context cookie(String var1, String var2);

    public Context cookie(String var1, String var2, int var3);

    public Context cookie(Cookie var1);

    public Context removeCookie(String var1);

    public Context removeCookie(String var1, String var2);

    public void redirect(String var1);

    public void redirect(String var1, int var2);

    public byte[] bodyAsBytes();

    public <T> T bodyAsClass(Class<T> var1);

    public String body();

    public long contentLength();

    public String contentType();

    public Context contentType(String var1);

    public Map<String, String> pathParamMap();

    public String pathParam(String var1);

    public String queryParam(String var1);

    default public String queryParam(String name, String defaultValue) {
        String val = this.queryParam(name);
        return val != null ? val : defaultValue;
    }

    public List<String> queryParams(String var1);

    public Map<String, String> queryParamMap();

    public String queryString();

    default public String formParam(String key) {
        return this.formParam(key, null);
    }

    default public String formParam(String key, String defaultValue) {
        List<String> values = this.formParamMap().get(key);
        return values == null || values.isEmpty() ? defaultValue : values.get(0);
    }

    default public List<String> formParams(String key) {
        List<String> values = this.formParamMap().get(key);
        return values != null ? values : Collections.emptyList();
    }

    public Map<String, List<String>> formParamMap();

    public String scheme();

    public Context sessionAttribute(String var1, Object var2);

    public <T> T sessionAttribute(String var1);

    public Map<String, Object> sessionAttributeMap();

    public String url();

    default public String fullUrl() {
        String url = this.url();
        String qs = this.queryString();
        return qs == null ? url : url + "?" + qs;
    }

    public String contextPath();

    default public String userAgent() {
        return this.header("User-Agent");
    }

    public Context status(int var1);

    public int status();

    public Context text(String var1);

    public Context html(String var1);

    public Context json(Object var1);

    public <E> Context jsonStream(Stream<E> var1);

    public <E> Context jsonStream(Iterator<E> var1);

    public Context write(String var1);

    default public Context render(String name) {
        return this.render(name, Collections.emptyMap());
    }

    public Context render(String var1, Map<String, Object> var2);

    public Map<String, String> headerMap();

    public String header(String var1);

    public Context header(String var1, String var2);

    public String responseHeader(String var1);

    public String host();

    public String ip();

    public boolean isMultipart();

    public boolean isMultipartFormData();

    public String method();

    public String path();

    public int port();

    public String protocol();

    public UploadedFile uploadedFile(String var1);

    public List<UploadedFile> uploadedFiles(String var1);

    public List<UploadedFile> uploadedFiles();

    public static class Cookie {
        private static final ZonedDateTime EXPIRED = ZonedDateTime.of(LocalDateTime.of(2000, 1, 1, 0, 0, 0), ZoneId.of("GMT"));
        private static final DateTimeFormatter RFC_1123_DATE_TIME = DateTimeFormatter.RFC_1123_DATE_TIME;
        private static final String PARAM_SEPARATOR = "; ";
        private final String name;
        private final String value;
        private String domain;
        private ZonedDateTime expires;
        private Duration maxAge;
        private String path;
        private boolean secure;
        private boolean httpOnly;

        private Cookie(String name, String value) {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException("name required");
            }
            this.name = name;
            this.value = value;
        }

        public static Cookie expired(String name) {
            return new Cookie(name, "").expires(EXPIRED);
        }

        public static Cookie of(String name, String value) {
            return new Cookie(name, value);
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public String domain() {
            return this.domain;
        }

        public Cookie domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Duration maxAge() {
            return this.maxAge;
        }

        public Cookie maxAge(Duration maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public ZonedDateTime expires() {
            return this.expires;
        }

        public Cookie expires(ZonedDateTime expires) {
            this.expires = expires;
            return this;
        }

        public String path() {
            return this.path;
        }

        public Cookie path(String path) {
            this.path = path;
            return this;
        }

        public boolean secure() {
            return this.secure;
        }

        public Cookie secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public boolean httpOnly() {
            return this.httpOnly;
        }

        public Cookie httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(60);
            result.append(this.name).append('=').append(this.value);
            if (this.expires != null) {
                result.append(PARAM_SEPARATOR);
                result.append("Expires=");
                result.append(this.expires.format(RFC_1123_DATE_TIME));
            }
            if (this.maxAge != null && !this.maxAge.isNegative() && !this.maxAge.isZero()) {
                result.append(PARAM_SEPARATOR);
                result.append("Max-Age=");
                result.append(this.maxAge.getSeconds());
            }
            if (this.domain != null) {
                result.append(PARAM_SEPARATOR);
                result.append("Domain=");
                result.append(this.domain);
            }
            if (this.path != null) {
                result.append(PARAM_SEPARATOR);
                result.append("Path=");
                result.append(this.path);
            }
            if (this.secure) {
                result.append(PARAM_SEPARATOR);
                result.append("Secure");
            }
            if (this.httpOnly) {
                result.append(PARAM_SEPARATOR);
                result.append("HttpOnly");
            }
            return result.toString();
        }
    }
}

