/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.jex.Context;
import io.avaje.jex.ErrorHandling;
import io.avaje.jex.Jex;
import io.avaje.jex.Routing;
import io.avaje.jex.TemplateRender;
import io.avaje.jex.core.ExceptionManager;
import io.avaje.jex.core.HttpMethodMap;
import io.avaje.jex.core.JacksonJsonService;
import io.avaje.jex.core.TemplateManager;
import io.avaje.jex.spi.JsonService;
import io.avaje.jex.spi.SpiContext;
import io.avaje.jex.spi.SpiServiceManager;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Stream;

class CoreServiceManager
implements SpiServiceManager {
    public static final String UTF_8 = "UTF-8";
    private final HttpMethodMap methodMap = new HttpMethodMap();
    private final JsonService jsonService;
    private final ExceptionManager exceptionHandler;
    private final TemplateManager templateManager;

    static SpiServiceManager create(Jex jex) {
        return new Builder(jex).build();
    }

    CoreServiceManager(JsonService jsonService, ErrorHandling errorHandling, TemplateManager templateManager) {
        this.jsonService = jsonService;
        this.exceptionHandler = new ExceptionManager(errorHandling);
        this.templateManager = templateManager;
    }

    @Override
    public <T> T jsonRead(Class<T> clazz, SpiContext ctx) {
        return this.jsonService.jsonRead(clazz, ctx);
    }

    @Override
    public void jsonWrite(Object bean, SpiContext ctx) {
        this.jsonService.jsonWrite(bean, ctx);
    }

    @Override
    public <E> void jsonWriteStream(Stream<E> stream, SpiContext ctx) {
        try (Stream<E> stream2 = stream;){
            this.jsonService.jsonWriteStream(stream.iterator(), ctx);
        }
    }

    @Override
    public <E> void jsonWriteStream(Iterator<E> iterator, SpiContext ctx) {
        try {
            this.jsonService.jsonWriteStream(iterator, ctx);
        }
        finally {
            this.maybeClose(iterator);
        }
    }

    @Override
    public void maybeClose(Object iterator) {
        if (AutoCloseable.class.isAssignableFrom(iterator.getClass())) {
            try {
                ((AutoCloseable)iterator).close();
            }
            catch (Exception e) {
                throw new RuntimeException("Error closing iterator " + iterator, e);
            }
        }
    }

    @Override
    public Routing.Type lookupRoutingType(String method) {
        return this.methodMap.get(method);
    }

    @Override
    public void handleException(SpiContext ctx, Exception e) {
        this.exceptionHandler.handle(ctx, e);
    }

    @Override
    public void render(Context ctx, String name, Map<String, Object> model) {
        this.templateManager.render(ctx, name, model);
    }

    @Override
    public String requestCharset(Context ctx) {
        return CoreServiceManager.parseCharset(ctx.header("Content-Type"));
    }

    static String parseCharset(String header) {
        if (header != null) {
            for (String val : header.split(";")) {
                if (!(val = val.trim()).regionMatches(true, 0, "charset", 0, "charset".length())) continue;
                return val.split("=")[1].trim();
            }
        }
        return UTF_8;
    }

    @Override
    public Map<String, List<String>> formParamMap(Context ctx, String charset) {
        return this.parseParamMap(ctx.body(), charset);
    }

    @Override
    public Map<String, List<String>> parseParamMap(String body, String charset) {
        if (body == null || body.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
            for (String pair : body.split("&")) {
                String[] split1 = pair.split("=", 2);
                String key = URLDecoder.decode(split1[0], charset);
                String val = split1.length > 1 ? URLDecoder.decode(split1[1], charset) : "";
                map.computeIfAbsent(key, s -> new ArrayList()).add(val);
            }
            return map;
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class Builder {
        private final Jex jex;

        Builder(Jex jex) {
            this.jex = jex;
        }

        SpiServiceManager build() {
            return new CoreServiceManager(this.initJsonService(), this.jex.errorHandling(), this.initTemplateMgr());
        }

        JsonService initJsonService() {
            JsonService jsonService = this.jex.config.jsonService;
            if (jsonService != null) {
                return jsonService;
            }
            return this.detectJackson() ? this.defaultJacksonService() : null;
        }

        JsonService defaultJacksonService() {
            return new JacksonJsonService();
        }

        boolean detectJackson() {
            try {
                Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        TemplateManager initTemplateMgr() {
            TemplateManager mgr = new TemplateManager();
            mgr.register(this.jex.config.renderers);
            for (TemplateRender render : ServiceLoader.load(TemplateRender.class)) {
                mgr.registerDefault(render);
            }
            return mgr;
        }
    }
}

