/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.jex.Jex;
import io.avaje.jex.StaticFileConfig;
import io.avaje.jex.StaticFileSource;
import java.util.ArrayList;
import java.util.List;

class DefaultStaticFileConfig
implements StaticFileConfig {
    private final List<StaticFileSource> sources = new ArrayList<StaticFileSource>();
    private final Jex jex;

    DefaultStaticFileConfig(Jex jex) {
        this.jex = jex;
    }

    @Override
    public Jex addClasspath(String path) {
        return this.addClasspath("/", path);
    }

    @Override
    public Jex addClasspath(String urlPrefix, String path) {
        this.sources.add(new StaticFileSource(urlPrefix, path, StaticFileSource.Location.CLASSPATH));
        return this.jex;
    }

    @Override
    public Jex addExternal(String path) {
        return this.addExternal("/", path);
    }

    @Override
    public Jex addExternal(String urlPrefix, String path) {
        this.sources.add(new StaticFileSource(urlPrefix, path, StaticFileSource.Location.EXTERNAL));
        return this.jex;
    }

    @Override
    public List<StaticFileSource> getSources() {
        return this.sources;
    }
}

