/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.routes;

import io.avaje.jex.AccessManager;
import io.avaje.jex.Context;
import io.avaje.jex.Handler;
import io.avaje.jex.Jex;
import io.avaje.jex.Role;
import io.avaje.jex.Routing;
import io.avaje.jex.routes.FilterEntry;
import io.avaje.jex.routes.PathParser;
import io.avaje.jex.routes.RouteEntry;
import io.avaje.jex.routes.RouteIndex;
import io.avaje.jex.routes.Routes;
import io.avaje.jex.spi.SpiRoutes;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;

public class RoutesBuilder {
    private final EnumMap<Routing.Type, RouteIndex> typeMap = new EnumMap(Routing.Type.class);
    private final List<SpiRoutes.Entry> before = new ArrayList<SpiRoutes.Entry>();
    private final List<SpiRoutes.Entry> after = new ArrayList<SpiRoutes.Entry>();
    private final boolean ignoreTrailingSlashes;
    private final AccessManager accessManager;

    public RoutesBuilder(Routing routing, Jex jex) {
        this.accessManager = jex.inner.accessManager;
        this.ignoreTrailingSlashes = jex.inner.ignoreTrailingSlashes;
        block4: for (Routing.Entry handler : routing.all()) {
            switch (handler.getType()) {
                case BEFORE: {
                    this.before.add(this.filter(handler));
                    continue block4;
                }
                case AFTER: {
                    this.after.add(this.filter(handler));
                    continue block4;
                }
            }
            this.typeMap.computeIfAbsent(handler.getType(), h -> new RouteIndex()).add(this.convert(handler));
        }
    }

    private FilterEntry filter(Routing.Entry entry) {
        return new FilterEntry(entry, this.ignoreTrailingSlashes);
    }

    private SpiRoutes.Entry convert(Routing.Entry handler) {
        PathParser pathParser = new PathParser(handler.getPath(), this.ignoreTrailingSlashes);
        return new RouteEntry(pathParser, this.extractHandler(handler));
    }

    private Handler extractHandler(Routing.Entry entry) {
        if (entry.getRoles().isEmpty() || this.accessManager == null) {
            return entry.getHandler();
        }
        return new AccessHandler(this.accessManager, entry.getHandler(), entry.getRoles());
    }

    public SpiRoutes build() {
        return new Routes(this.typeMap, this.before, this.after);
    }

    static class AccessHandler
    implements Handler {
        private final AccessManager manager;
        private final Handler handler;
        private final Set<Role> roles;

        AccessHandler(AccessManager manager, Handler handler, Set<Role> roles) {
            this.manager = manager;
            this.handler = handler;
            this.roles = roles;
        }

        @Override
        public void handle(Context ctx) {
            this.manager.manage(this.handler, ctx, this.roles);
        }
    }
}

