/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.routes;

import java.util.List;

abstract class PathSegment {
    PathSegment() {
    }

    abstract String asRegexString(boolean var1);

    abstract void addParamName(List<String> var1);

    static class Wildcard
    extends PathSegment {
        Wildcard() {
        }

        @Override
        public String asRegexString(boolean extract) {
            return extract ? "(.*?)" : ".*?";
        }

        @Override
        public void addParamName(List<String> paramNames) {
            paramNames.add(null);
        }
    }

    static class Literal
    extends PathSegment {
        private final String content;

        Literal(String content) {
            this.content = content;
        }

        @Override
        public String asRegexString(boolean extract) {
            return this.content;
        }

        @Override
        public void addParamName(List<String> paramNames) {
        }
    }

    static class Parameter
    extends PathSegment {
        private final String name;
        private final String regex;

        Parameter(String param) {
            String[] split = param.split(":", 2);
            this.name = split[0];
            this.regex = split.length == 1 ? "[^/]+?" : split[1];
        }

        @Override
        public String asRegexString(boolean extract) {
            return extract ? "(" + this.regex + ")" : this.regex;
        }

        @Override
        public void addParamName(List<String> paramNames) {
            paramNames.add(this.name);
        }
    }
}

