/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.jetty;

import io.avaje.jex.Context;
import io.avaje.jex.Routing;
import io.avaje.jex.UploadedFile;
import io.avaje.jex.core.ServiceManager;
import io.avaje.jex.http.RedirectResponse;
import io.avaje.jex.jetty.ContextUtil;
import io.avaje.jex.spi.SpiContext;
import io.avaje.jex.spi.SpiRoutes;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

class JexHttpContext
implements SpiContext {
    private final ServiceManager mgr;
    protected final HttpServletRequest req;
    private final HttpServletResponse res;
    private final Map<String, String> pathParams;
    private final List<String> splats;
    private final String matchedPath;
    private String characterEncoding;
    private Routing.Type mode;
    private Map<String, List<String>> formParamMap;

    JexHttpContext(ServiceManager mgr, HttpServletRequest req, HttpServletResponse res, String matchedPath) {
        this.mgr = mgr;
        this.req = req;
        this.res = res;
        this.matchedPath = matchedPath;
        this.pathParams = Collections.emptyMap();
        this.splats = null;
    }

    JexHttpContext(ServiceManager mgr, HttpServletRequest req, HttpServletResponse res, String matchedPath, SpiRoutes.Params params) {
        this.mgr = mgr;
        this.req = req;
        this.res = res;
        this.matchedPath = matchedPath;
        this.pathParams = params.pathParams;
        this.splats = params.splats;
    }

    @Override
    public void setMode(Routing.Type mode) {
        this.mode = mode;
    }

    private String characterEncoding() {
        if (this.characterEncoding == null) {
            this.characterEncoding = ContextUtil.getRequestCharset(this);
        }
        return this.characterEncoding;
    }

    @Override
    public HttpServletRequest req() {
        return this.req;
    }

    @Override
    public HttpServletResponse res() {
        return this.res;
    }

    @Override
    public Context attribute(String key, Object value) {
        this.req.setAttribute(key, value);
        return this;
    }

    @Override
    public <T> T attribute(String key) {
        return (T)this.req.getAttribute(key);
    }

    @Override
    public Map<String, Object> attributeMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Enumeration names = this.req.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            map.put(name, this.req.getAttribute(name));
        }
        return map;
    }

    @Override
    public String cookie(String name) {
        Cookie[] cookies = this.req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    @Override
    public Map<String, String> cookieMap() {
        Cookie[] cookies = this.req.getCookies();
        if (cookies == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Cookie cookie : cookies) {
            map.put(cookie.getName(), cookie.getValue());
        }
        return map;
    }

    @Override
    public Context cookie(String name, String value) {
        return this.cookie(name, value, -1);
    }

    @Override
    public Context cookie(String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        return this.cookie(cookie);
    }

    @Override
    public Context cookie(Cookie cookie) {
        if (cookie.getPath() == null) {
            cookie.setPath("/");
        }
        this.res.addCookie(cookie);
        return this;
    }

    @Override
    public Context removeCookie(String name) {
        return this.removeCookie(name, null);
    }

    @Override
    public Context removeCookie(String name, String path) {
        if (path == null) {
            path = "/";
        }
        Cookie cookie = new Cookie(name, "");
        cookie.setPath(path);
        cookie.setMaxAge(0);
        this.res.addCookie(cookie);
        return this;
    }

    @Override
    public void redirect(String location) {
        this.redirect(location, 302);
    }

    @Override
    public void redirect(String location, int statusCode) {
        this.res.setHeader("Location", location);
        this.status(statusCode);
        if (this.mode == Routing.Type.BEFORE) {
            throw new RedirectResponse(statusCode);
        }
    }

    @Override
    public String matchedPath() {
        return this.matchedPath;
    }

    @Override
    public InputStream inputStream() {
        try {
            return this.req.getInputStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public <T> T bodyAsClass(Class<T> clazz) {
        return this.mgr.jsonRead(clazz, this);
    }

    @Override
    public byte[] bodyAsBytes() {
        return ContextUtil.readBody(this.req);
    }

    @Override
    public String body() {
        return new String(this.bodyAsBytes(), Charset.forName(this.characterEncoding()));
    }

    @Override
    public long contentLength() {
        return this.req.getContentLengthLong();
    }

    @Override
    public String splat(int position) {
        return this.splats == null ? null : this.splats.get(position);
    }

    @Override
    public List<String> splats() {
        return this.splats == null ? Collections.emptyList() : this.splats;
    }

    @Override
    public Map<String, String> pathParamMap() {
        return this.pathParams;
    }

    @Override
    public String pathParam(String name) {
        return this.pathParams.get(name);
    }

    @Override
    public String queryParam(String name) {
        String[] vals = this.req.getParameterValues(name);
        if (vals == null || vals.length == 0) {
            return null;
        }
        return vals[0];
    }

    @Override
    public List<String> queryParams(String name) {
        String[] vals = this.req.getParameterValues(name);
        if (vals == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(vals);
    }

    @Override
    public Map<String, String> queryParamMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration names = this.req.getParameterNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            map.put(key, this.queryParam(key));
        }
        return map;
    }

    @Override
    public String queryString() {
        return this.req.getQueryString();
    }

    @Override
    public String formParam(String key) {
        return this.formParam(key, null);
    }

    @Override
    public String formParam(String key, String defaultValue) {
        List<String> values = this.formParamMap().get(key);
        return values == null || values.isEmpty() ? defaultValue : values.get(0);
    }

    @Override
    public List<String> formParams(String key) {
        List<String> values = this.formParamMap().get(key);
        return values != null ? values : Collections.emptyList();
    }

    @Override
    public Map<String, List<String>> formParamMap() {
        if (this.formParamMap == null) {
            this.formParamMap = this.initFormParamMap();
        }
        return this.formParamMap;
    }

    private Map<String, List<String>> initFormParamMap() {
        if (this.isMultipartFormData()) {
            return this.mgr.multiPartForm(this.req);
        }
        return ContextUtil.formParamMap(this.body(), this.characterEncoding());
    }

    @Override
    public String scheme() {
        return this.req.getScheme();
    }

    @Override
    public Context sessionAttribute(String key, Object value) {
        this.req.getSession().setAttribute(key, value);
        return this;
    }

    @Override
    public <T> T sessionAttribute(String key) {
        return (T)this.req.getSession().getAttribute(key);
    }

    @Override
    public Map<String, Object> sessionAttributeMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        HttpSession session = this.req.getSession();
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            map.put(name, session.getAttribute(name));
        }
        return map;
    }

    @Override
    public String url() {
        return this.req.getRequestURL().toString();
    }

    @Override
    public String fullUrl() {
        String qs = this.queryString();
        return qs == null ? this.url() : this.url() + "?" + qs;
    }

    @Override
    public String contextPath() {
        return this.req.getContextPath();
    }

    @Override
    public String userAgent() {
        return this.req.getHeader("User-Agent");
    }

    @Override
    public Context status(int statusCode) {
        this.res.setStatus(statusCode);
        return this;
    }

    @Override
    public int status() {
        return this.res.getStatus();
    }

    @Override
    public String contentType() {
        return this.req.getContentType();
    }

    @Override
    public Context contentType(String contentType) {
        this.res.setContentType(contentType);
        return this;
    }

    @Override
    public Map<String, String> headerMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration names = this.req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            map.put(name, this.req.getHeader(name));
        }
        return map;
    }

    @Override
    public String header(String key) {
        return this.req.getHeader(key);
    }

    @Override
    public void header(String key, String value) {
        this.res.setHeader(key, value);
    }

    @Override
    public String host() {
        return this.req.getHeader("Host");
    }

    @Override
    public String ip() {
        return this.req.getRemoteAddr();
    }

    @Override
    public boolean isMultipart() {
        String type = this.header("Content-Type");
        return type != null && type.toLowerCase().contains("multipart/");
    }

    @Override
    public boolean isMultipartFormData() {
        String type = this.header("Content-Type");
        return type != null && type.toLowerCase().contains("multipart/form-data");
    }

    @Override
    public String method() {
        return this.req.getMethod();
    }

    @Override
    public String path() {
        return this.req.getRequestURI();
    }

    @Override
    public int port() {
        return this.req.getServerPort();
    }

    @Override
    public String protocol() {
        return this.req.getProtocol();
    }

    @Override
    public Context text(String content) {
        this.res.setContentType("text/plain");
        return this.write(content);
    }

    @Override
    public Context html(String content) {
        this.res.setContentType("text/html");
        return this.write(content);
    }

    @Override
    public Context json(Object bean) {
        this.contentType("application/json");
        this.mgr.jsonWrite(bean, this);
        return this;
    }

    @Override
    public <E> Context jsonStream(Stream<E> stream) {
        this.contentType("application/x-json-stream");
        this.mgr.jsonWriteStream(stream, (SpiContext)this);
        return this;
    }

    @Override
    public <E> Context jsonStream(Iterator<E> iterator) {
        this.contentType("application/x-json-stream");
        this.mgr.jsonWriteStream(iterator, (SpiContext)this);
        return this;
    }

    @Override
    public Context write(String content) {
        try {
            this.res.getWriter().write(content);
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Context render(String name) {
        return this.render(name, Collections.emptyMap());
    }

    @Override
    public Context render(String name, Map<String, Object> model) {
        this.mgr.render(this, name, model);
        return this;
    }

    @Override
    public OutputStream outputStream() {
        try {
            return this.res.getOutputStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public UploadedFile uploadedFile(String name) {
        List<UploadedFile> files = this.uploadedFiles(name);
        return files.isEmpty() ? null : files.get(0);
    }

    @Override
    public List<UploadedFile> uploadedFiles(String name) {
        if (!this.isMultipartFormData()) {
            return Collections.emptyList();
        }
        return this.mgr.uploadedFiles(this.req, name);
    }

    @Override
    public List<UploadedFile> uploadedFiles() {
        if (!this.isMultipartFormData()) {
            return Collections.emptyList();
        }
        return this.mgr.uploadedFiles(this.req);
    }
}

