/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.jetty;

import io.avaje.jex.Jex;
import java.lang.reflect.Constructor;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JettyBuilder {
    private static final Logger log = LoggerFactory.getLogger(JettyBuilder.class);
    private final Jex.Inner inner;
    private final Jex.Jetty config;

    JettyBuilder(Jex jex) {
        this.inner = jex.inner;
        this.config = jex.jetty;
    }

    Server build() {
        Server jetty = new Server(this.pool());
        ServerConnector connector = new ServerConnector(jetty);
        connector.setPort(this.inner.port);
        if (this.inner.host != null) {
            connector.setHost(this.inner.host);
        }
        jetty.setConnectors(new Connector[]{connector});
        return jetty;
    }

    private ThreadPool pool() {
        if (this.config.virtualThreads) {
            return this.virtualThreadBasePool();
        }
        return this.config.maxThreads == 0 ? new QueuedThreadPool() : new QueuedThreadPool(this.config.maxThreads);
    }

    private ThreadPool virtualThreadBasePool() {
        try {
            Class<?> aClass = Class.forName("io.avaje.jex.jetty.threadpool.VirtualThreadPool");
            Constructor<?> constructor = aClass.getConstructor(new Class[0]);
            return (ThreadPool)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to start Loom threadPool", e);
        }
    }
}

