/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.jex.Context;
import io.avaje.jex.ErrorHandling;
import io.avaje.jex.Jex;
import io.avaje.jex.TemplateRender;
import io.avaje.jex.UploadedFile;
import io.avaje.jex.core.ExceptionManager;
import io.avaje.jex.core.JacksonJsonService;
import io.avaje.jex.core.MultipartUtil;
import io.avaje.jex.core.TemplateManager;
import io.avaje.jex.spi.JsonService;
import io.avaje.jex.spi.SpiContext;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Stream;

public class ServiceManager {
    private final JsonService jsonService;
    private final ExceptionManager exceptionHandler;
    private final TemplateManager templateManager;
    private final MultipartUtil multipartUtil;

    public static ServiceManager create(Jex jex) {
        return new Builder(jex).build();
    }

    ServiceManager(JsonService jsonService, ErrorHandling errorHandling, TemplateManager templateManager, MultipartUtil multipartUtil) {
        this.jsonService = jsonService;
        this.exceptionHandler = new ExceptionManager(errorHandling);
        this.templateManager = templateManager;
        this.multipartUtil = multipartUtil;
    }

    public <T> T jsonRead(Class<T> clazz, SpiContext ctx) {
        return this.jsonService.jsonRead(clazz, ctx);
    }

    public void jsonWrite(Object bean, SpiContext ctx) {
        this.jsonService.jsonWrite(bean, ctx);
    }

    public <E> void jsonWriteStream(Stream<E> stream, SpiContext ctx) {
        try (Stream<E> stream2 = stream;){
            this.jsonService.jsonWriteStream(stream.iterator(), ctx);
        }
    }

    public <E> void jsonWriteStream(Iterator<E> iterator, SpiContext ctx) {
        try {
            this.jsonService.jsonWriteStream(iterator, ctx);
        }
        finally {
            this.maybeClose(iterator);
        }
    }

    private <E> void maybeClose(Object iterator) {
        if (AutoCloseable.class.isAssignableFrom(iterator.getClass())) {
            try {
                ((AutoCloseable)iterator).close();
            }
            catch (Exception e) {
                throw new RuntimeException("Error closing iterator " + iterator, e);
            }
        }
    }

    public void handleException(Context ctx, Exception e) {
        this.exceptionHandler.handle(ctx, e);
    }

    public void render(Context ctx, String name, Map<String, Object> model) {
        this.templateManager.render(ctx, name, model);
    }

    public List<UploadedFile> uploadedFiles(HttpServletRequest req) {
        return this.multipartUtil.uploadedFiles(req);
    }

    public List<UploadedFile> uploadedFiles(HttpServletRequest req, String name) {
        return this.multipartUtil.uploadedFiles(req, name);
    }

    public Map<String, List<String>> multiPartForm(HttpServletRequest req) {
        return this.multipartUtil.fieldMap(req);
    }

    private static class Builder {
        private final Jex jex;

        Builder(Jex jex) {
            this.jex = jex;
        }

        ServiceManager build() {
            return new ServiceManager(this.initJsonService(), this.jex.errorHandling(), this.initTemplateMgr(), this.initMultiPart());
        }

        JsonService initJsonService() {
            JsonService jsonService = this.jex.inner.jsonService;
            if (jsonService != null) {
                return jsonService;
            }
            return this.detectJackson() ? this.defaultJacksonService() : null;
        }

        JsonService defaultJacksonService() {
            return new JacksonJsonService();
        }

        boolean detectJackson() {
            try {
                Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        TemplateManager initTemplateMgr() {
            TemplateManager mgr = new TemplateManager();
            mgr.register(this.jex.inner.renderers);
            for (TemplateRender render : ServiceLoader.load(TemplateRender.class)) {
                mgr.registerDefault(render);
            }
            return mgr;
        }

        MultipartUtil initMultiPart() {
            MultipartConfigElement config = this.jex.inner.multipartConfig;
            if (config == null) {
                int fileThreshold = this.jex.inner.multipartFileThreshold;
                config = new MultipartConfigElement(System.getProperty("java.io.tmpdir"), -1L, -1L, fileThreshold);
            }
            return new MultipartUtil(config);
        }
    }
}

