/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.routes;

import io.avaje.jex.spi.SpiRoutes;
import java.util.ArrayList;
import java.util.List;

class RouteIndex {
    private final Entry[] entries = new Entry[6];
    private List<SpiRoutes.Entry> wildcardEntries = new ArrayList<SpiRoutes.Entry>();

    RouteIndex() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = new Entry();
        }
    }

    private int index(int segmentCount) {
        return Math.min(segmentCount, 5);
    }

    void add(SpiRoutes.Entry entry) {
        if (entry.includesWildcard()) {
            this.wildcardEntries.add(entry);
        } else {
            this.entries[this.index(entry.getSegmentCount())].add(entry);
        }
    }

    SpiRoutes.Entry match(String pathInfo) {
        SpiRoutes.Entry match = this.entries[this.index(this.segmentCount(pathInfo))].match(pathInfo);
        if (match != null) {
            return match;
        }
        for (SpiRoutes.Entry wildcardEntry : this.wildcardEntries) {
            if (!wildcardEntry.matches(pathInfo)) continue;
            return wildcardEntry;
        }
        return null;
    }

    private int segmentCount(String pathInfo) {
        if ("/".equals(pathInfo)) {
            return 0;
        }
        int last = pathInfo.length() - 1;
        int count = 1;
        for (int i = 1; i < last; ++i) {
            if (pathInfo.charAt(i) != '/') continue;
            ++count;
        }
        return count;
    }

    private static class Entry {
        private final List<SpiRoutes.Entry> list = new ArrayList<SpiRoutes.Entry>();

        private Entry() {
        }

        void add(SpiRoutes.Entry entry) {
            this.list.add(entry);
        }

        SpiRoutes.Entry match(String pathInfo) {
            for (SpiRoutes.Entry entry : this.list) {
                if (!entry.matches(pathInfo)) continue;
                return entry;
            }
            return null;
        }
    }
}

