/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.jetty;

import io.avaje.jex.Jex;
import io.avaje.jex.jetty.threadpool.VirtualThreadPool;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JettyBuilder {
    private static final Logger log = LoggerFactory.getLogger(JettyBuilder.class);
    private final Jex.Inner inner;
    private final Jex.Jetty config;

    JettyBuilder(Jex jex) {
        this.inner = jex.inner;
        this.config = jex.jetty;
    }

    Server build() {
        Server jetty = new Server(this.pool());
        ServerConnector connector = new ServerConnector(jetty);
        connector.setPort(this.inner.port);
        jetty.setConnectors(new Connector[]{connector});
        return jetty;
    }

    private ThreadPool pool() {
        if (this.config.virtualThreads) {
            return new VirtualThreadPool();
        }
        return this.config.maxThreads == 0 ? new QueuedThreadPool() : new QueuedThreadPool(this.config.maxThreads);
    }
}

