/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.jetty;

import io.avaje.jex.StaticFileSource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.EmptyResource;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StaticHandler {
    private static final Logger log = LoggerFactory.getLogger(StaticHandler.class);
    private final List<ResourceHandler> handlers = new ArrayList<ResourceHandler>();
    private final boolean preCompress;

    StaticHandler(boolean preCompress) {
        this.preCompress = preCompress;
    }

    void addStaticFileConfig(StaticFileSource config) {
        ResourceHandler handler;
        if ("/webjars".equals(config.getPath())) {
            handler = new WebjarHandler();
        } else {
            PrefixableHandler h = new PrefixableHandler(config.getUrlPathPrefix());
            h.setResourceBase(this.getResourcePath(config));
            h.setDirAllowed(false);
            h.setEtags(true);
            handler = h;
        }
        log.info("Static file handler added {}", (Object)config);
        try {
            handler.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Error starting Jetty static resource handler", e);
        }
        this.handlers.add(handler);
    }

    private String getResourcePath(StaticFileSource config) {
        if (config.getLocation() == StaticFileSource.Location.CLASSPATH) {
            Resource resource = Resource.newClassPathResource((String)config.getPath());
            if (resource == null) {
                throw new RuntimeException(this.noSuchDir(config) + " Depending on your setup, empty folders might not get copied to classpath.");
            }
            return resource.toString();
        }
        File path = new File(config.getPath());
        if (!path.exists()) {
            throw new RuntimeException(this.noSuchDir(config) + " path: " + path.getAbsolutePath());
        }
        return config.getPath();
    }

    private String noSuchDir(StaticFileSource config) {
        return "Static resource directory with path: '" + config.getPath() + "' does not exist.";
    }

    boolean handle(HttpServletRequest req, HttpServletResponse res) {
        String target = (String)req.getAttribute("jetty-target");
        Request baseRequest = (Request)req.getAttribute("jetty-request");
        for (ResourceHandler handler : this.handlers) {
            try {
                Resource resource = handler.getResource(target);
                if (!this.isFile(resource) && !this.isDirectoryWithWelcomeFile(resource, handler, target)) continue;
                res.setContentType(null);
                handler.handle(target, baseRequest, req, res);
                req.setAttribute("handled-as-static-file", (Object)true);
                return true;
            }
            catch (Exception e) {
                log.error("Exception occurred while handling static resource", (Throwable)e);
            }
        }
        return false;
    }

    private boolean isFile(Resource resource) {
        return resource != null && resource.exists() && !resource.isDirectory();
    }

    private boolean isDirectoryWithWelcomeFile(Resource resource, ResourceHandler handler, String target) {
        if (target.endsWith("/")) {
            target = target.substring(0, target.length() - 1);
        }
        String path = target + "/index.html";
        if (resource == null || !resource.isDirectory()) {
            return false;
        }
        try {
            Resource indexHtml = handler.getResource(path);
            return indexHtml != null && indexHtml.exists();
        }
        catch (IOException e) {
            log.warn("Error checking for welcome file", (Throwable)e);
            return false;
        }
    }

    private static class PrefixableHandler
    extends ResourceHandler {
        private final String urlPathPrefix;

        PrefixableHandler(String urlPathPrefix) {
            this.urlPathPrefix = urlPathPrefix;
        }

        public Resource getResource(String path) throws IOException {
            if (this.urlPathPrefix.equals("/")) {
                return super.getResource(path);
            }
            String targetPath = this.target(path);
            if ("".equals(targetPath)) {
                return super.getResource("/");
            }
            if (!path.startsWith(this.urlPathPrefix)) {
                return EmptyResource.INSTANCE;
            }
            if (!targetPath.startsWith("/")) {
                return EmptyResource.INSTANCE;
            }
            return super.getResource(targetPath);
        }

        private String target(String path) {
            if (path.startsWith(this.urlPathPrefix)) {
                return path.substring(this.urlPathPrefix.length());
            }
            return path;
        }
    }

    private static class WebjarHandler
    extends ResourceHandler {
        private WebjarHandler() {
        }

        public Resource getResource(String path) throws IOException {
            Resource resource = Resource.newClassPathResource((String)("META-INF/resources" + path));
            return resource != null ? resource : super.getResource(path);
        }
    }
}

