/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.jex.AccessManager;
import io.avaje.jex.DefaultErrorHandling;
import io.avaje.jex.DefaultRouting;
import io.avaje.jex.DefaultStaticFileConfig;
import io.avaje.jex.ErrorHandling;
import io.avaje.jex.ExceptionHandler;
import io.avaje.jex.Routing;
import io.avaje.jex.StaticFileConfig;
import io.avaje.jex.TemplateRender;
import io.avaje.jex.jetty.JettyStartServer;
import io.avaje.jex.spi.JsonService;
import io.avaje.jex.spi.SpiStartServer;
import jakarta.servlet.MultipartConfigElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class Jex {
    private final Routing routing = new DefaultRouting();
    private final ErrorHandling errorHandling = new DefaultErrorHandling();
    private final StaticFileConfig staticFiles;
    public final Inner inner = new Inner();
    public final Jetty jetty = new Jetty();

    private Jex() {
        this.staticFiles = new DefaultStaticFileConfig(this);
    }

    public static Jex create() {
        return new Jex();
    }

    public Jex errorHandling(ErrorHandling.Service service) {
        service.add(this.errorHandling);
        return this;
    }

    public ErrorHandling errorHandling() {
        return this.errorHandling;
    }

    public Jex routing(Routing.Service routes) {
        this.routing.add(routes);
        return this;
    }

    public Jex routing(Collection<Routing.Service> routes) {
        this.routing.addAll(routes);
        return this;
    }

    public Routing routing() {
        return this.routing;
    }

    public Jex accessManager(AccessManager accessManager) {
        this.inner.accessManager = accessManager;
        return this;
    }

    public Jex jsonService(JsonService jsonService) {
        this.inner.jsonService = jsonService;
        return this;
    }

    public Jex configure(Consumer<Jex> configure) {
        configure.accept(this);
        return this;
    }

    public <T extends Exception> Jex exception(Class<T> exceptionClass, ExceptionHandler<T> handler) {
        this.errorHandling.exception(exceptionClass, handler);
        return this;
    }

    public Jex port(int port) {
        this.inner.port = port;
        return this;
    }

    public Jex context(String contextPath) {
        this.inner.contextPath = contextPath;
        return this;
    }

    public StaticFileConfig staticFiles() {
        return this.staticFiles;
    }

    public Jex register(TemplateRender renderer, String ... extensions) {
        for (String extension : extensions) {
            this.inner.renderers.put(extension, renderer);
        }
        return this;
    }

    public Server start() {
        Optional<SpiStartServer> start = ServiceLoader.load(SpiStartServer.class).findFirst();
        if (start.isEmpty()) {
            return new JettyStartServer().start(this);
        }
        return start.get().start(this);
    }

    public static interface Server {
        public void shutdown();
    }

    public static class Jetty {
        public boolean sessions = true;
        public boolean security = true;
        public SessionHandler sessionHandler;
        public ServletContextHandler contextHandler;
        public org.eclipse.jetty.server.Server server;
    }

    public static class Inner {
        public int port = 7001;
        public String contextPath = "/";
        public boolean prefer405 = true;
        public boolean ignoreTrailingSlashes = true;
        public boolean preCompressStaticFiles;
        public JsonService jsonService;
        public AccessManager accessManager;
        public MultipartConfigElement multipartConfig;
        public int multipartFileThreshold = 8192;
        public final Map<String, TemplateRender> renderers = new HashMap<String, TemplateRender>();
    }
}

