/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.jex.Handler;
import io.avaje.jex.Role;
import io.avaje.jex.Routing;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;

class DefaultRouting
implements Routing {
    private final List<Routing.Entry> handlers = new ArrayList<Routing.Entry>();
    private final Deque<String> pathDeque = new ArrayDeque<String>();

    DefaultRouting() {
    }

    @Override
    public List<Routing.Entry> all() {
        return this.handlers;
    }

    private String path(String path) {
        return String.join((CharSequence)"", this.pathDeque) + (String)(path.startsWith("/") || path.isEmpty() ? path : "/" + path);
    }

    private void addEndpoints(String path, Routing.Group group) {
        path = ((String)path).startsWith("/") ? path : "/" + (String)path;
        this.pathDeque.addLast((String)path);
        group.addGroup();
        this.pathDeque.removeLast();
    }

    @Override
    public Routing add(Routing.Service routes) {
        routes.add(this);
        return this;
    }

    @Override
    public Routing addAll(Collection<Routing.Service> routes) {
        for (Routing.Service route : routes) {
            route.add(this);
        }
        return this;
    }

    @Override
    public Routing path(String path, Routing.Group group) {
        this.addEndpoints(path, group);
        return this;
    }

    private void add(Routing.Type verb, String path, Handler handler, Set<Role> roles) {
        this.handlers.add(new Entry(verb, this.path(path), handler, roles));
    }

    private void addBefore(String path, Handler handler) {
        this.add(Routing.Type.BEFORE, this.path(path), handler, null);
    }

    private void addAfter(String path, Handler handler) {
        this.add(Routing.Type.AFTER, this.path(path), handler, null);
    }

    @Override
    public Routing get(String path, Handler handler, Set<Role> permittedRoles) {
        this.add(Routing.Type.GET, path, handler, permittedRoles);
        return this;
    }

    @Override
    public Routing get(String path, Handler handler) {
        this.get(path, handler, Collections.emptySet());
        return this;
    }

    @Override
    public Routing get(Handler handler) {
        this.get("", handler);
        return this;
    }

    @Override
    public Routing get(Handler handler, Set<Role> permittedRoles) {
        this.get("", handler, permittedRoles);
        return this;
    }

    @Override
    public Routing post(String path, Handler handler, Set<Role> permittedRoles) {
        this.add(Routing.Type.POST, path, handler, permittedRoles);
        return this;
    }

    @Override
    public Routing post(String path, Handler handler) {
        this.post(path, handler, Collections.emptySet());
        return this;
    }

    @Override
    public Routing post(Handler handler) {
        this.post("", handler);
        return this;
    }

    @Override
    public Routing post(Handler handler, Set<Role> permittedRoles) {
        this.post("", handler, permittedRoles);
        return this;
    }

    @Override
    public Routing before(String path, Handler handler) {
        this.addBefore(path, handler);
        return this;
    }

    @Override
    public Routing before(Handler handler) {
        this.before("/*", handler);
        return this;
    }

    @Override
    public Routing after(String path, Handler handler) {
        this.addAfter(path, handler);
        return this;
    }

    @Override
    public Routing after(Handler handler) {
        this.after("/*", handler);
        return this;
    }

    static class Entry
    implements Routing.Entry {
        private final Routing.Type type;
        private final String path;
        private final Handler handler;
        private final Set<Role> roles;

        Entry(Routing.Type type, String path, Handler handler, Set<Role> roles) {
            this.type = type;
            this.path = path;
            this.handler = handler;
            this.roles = roles;
        }

        @Override
        public Routing.Type getType() {
            return this.type;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public Handler getHandler() {
            return this.handler;
        }

        @Override
        public Set<Role> getRoles() {
            return this.roles;
        }
    }
}

