/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.routes;

import io.avaje.jex.routes.PathSegment;
import io.avaje.jex.routes.RegBuilder;
import io.avaje.jex.routes.UrlDecode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PathParser {
    private static final PathSegment.Wildcard WILDCARD = new PathSegment.Wildcard();
    private final String rawPath;
    private final List<String> paramNames = new ArrayList<String>();
    private final Pattern matchRegex;
    private final Pattern pathParamRegex;
    private int segmentCount;

    PathParser(String path, boolean ignoreTrailingSlashes) {
        this.rawPath = path;
        RegBuilder regBuilder = new RegBuilder();
        for (String rawSeg : path.split("/")) {
            if (rawSeg.isEmpty()) continue;
            ++this.segmentCount;
            PathSegment pathSegment = this.parseSegment(rawSeg);
            String paramName = regBuilder.add(pathSegment);
            if (paramName == null) continue;
            this.paramNames.add(paramName);
        }
        if (!ignoreTrailingSlashes && path.endsWith("/")) {
            ++this.segmentCount;
            regBuilder.trailingSlash();
        }
        this.matchRegex = regBuilder.matchRegex();
        this.pathParamRegex = regBuilder.extractRegex();
    }

    public boolean matches(String url) {
        return this.matchRegex.matcher(url).matches();
    }

    public Map<String, String> extractPathParams(String uri) {
        LinkedHashMap<String, String> pathMap = new LinkedHashMap<String, String>();
        List<String> values = this.values(uri);
        for (int i = 0; i < values.size(); ++i) {
            pathMap.put(this.paramNames.get(i), UrlDecode.decode(values.get(i)));
        }
        return pathMap;
    }

    private List<String> values(String uri) {
        Matcher matcher = this.pathParamRegex.matcher(uri);
        if (!matcher.find()) {
            return Collections.emptyList();
        }
        int i = matcher.groupCount();
        ArrayList<String> values = new ArrayList<String>(i);
        for (int j = 1; j <= i; ++j) {
            values.add(matcher.group(j));
        }
        return values;
    }

    private PathSegment parseSegment(String seg) {
        if (seg.startsWith("{")) {
            return new PathSegment.Parameter(seg.substring(1, seg.length() - 1));
        }
        if (seg.equals("*")) {
            return WILDCARD;
        }
        return new PathSegment.Literal(seg);
    }

    public String raw() {
        return this.rawPath;
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }
}

