/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.jex.Context;
import io.avaje.jex.ErrorHandling;
import io.avaje.jex.Jex;
import io.avaje.jex.TemplateRender;
import io.avaje.jex.UploadedFile;
import io.avaje.jex.core.ExceptionManager;
import io.avaje.jex.core.JacksonJsonService;
import io.avaje.jex.core.MultipartUtil;
import io.avaje.jex.core.TemplateManager;
import io.avaje.jex.spi.JsonService;
import io.avaje.jex.spi.SpiContext;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.HttpServletRequest;

public class ServiceManager {
    private final JsonService jsonService;
    private final ExceptionManager exceptionHandler;
    private final TemplateManager templateManager;
    private final MultipartUtil multipartUtil;

    public static ServiceManager create(Jex jex) {
        return new Builder(jex).build();
    }

    ServiceManager(JsonService jsonService, ErrorHandling errorHandling, TemplateManager templateManager, MultipartUtil multipartUtil) {
        this.jsonService = jsonService;
        this.exceptionHandler = new ExceptionManager(errorHandling);
        this.templateManager = templateManager;
        this.multipartUtil = multipartUtil;
    }

    public <T> T jsonRead(Class<T> clazz, SpiContext ctx) {
        return this.jsonService.jsonRead(clazz, ctx);
    }

    public void jsonWrite(Object bean, SpiContext ctx) {
        this.jsonService.jsonWrite(bean, ctx);
    }

    public void handleException(Context ctx, Exception e) {
        this.exceptionHandler.handle(ctx, e);
    }

    public void render(Context ctx, String name, Map<String, Object> model) {
        this.templateManager.render(ctx, name, model);
    }

    public List<UploadedFile> uploadedFiles(HttpServletRequest req, String name) {
        return this.multipartUtil.uploadedFiles(req, name);
    }

    public Map<String, List<String>> multiPartForm(HttpServletRequest req) {
        return this.multipartUtil.fieldMap(req);
    }

    private static class Builder {
        private final Jex jex;
        private ErrorHandling errorHandling;
        private JsonService jsonService;
        private TemplateManager templateManager;
        private MultipartUtil multipartUtil;

        Builder(Jex jex) {
            this.jex = jex;
        }

        ServiceManager build() {
            this.errorHandling = this.jex.errorHandling();
            this.templateManager = this.initTemplateMgr();
            this.jsonService = this.initJsonService();
            this.multipartUtil = this.initMultiPart();
            return new ServiceManager(this.jsonService, this.errorHandling, this.templateManager, this.multipartUtil);
        }

        JsonService initJsonService() {
            JsonService jsonService = this.jex.inner.jsonService;
            if (jsonService != null) {
                return jsonService;
            }
            return this.detectJackson() ? this.defaultJacksonService() : null;
        }

        JsonService defaultJacksonService() {
            return new JacksonJsonService();
        }

        boolean detectJackson() {
            try {
                Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        TemplateManager initTemplateMgr() {
            TemplateManager mgr = new TemplateManager();
            mgr.register(this.jex.inner.renderers);
            for (TemplateRender render : ServiceLoader.load(TemplateRender.class)) {
                mgr.registerDefault(render);
            }
            return mgr;
        }

        MultipartUtil initMultiPart() {
            MultipartConfigElement config = this.jex.inner.multipartConfig;
            if (config == null) {
                int fileThreshold = this.jex.inner.multipartFileThreshold;
                config = new MultipartConfigElement(System.getProperty("java.io.tmpdir"), -1L, -1L, fileThreshold);
            }
            return new MultipartUtil(config);
        }
    }
}

