/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.test;

import io.avaje.applog.AppLog;
import io.avaje.inject.BeanScope;
import io.avaje.inject.test.GlobalInitialise;
import io.avaje.inject.test.InjectJunitExtension;
import io.avaje.inject.test.Plugin;
import io.avaje.inject.test.TestBeans;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.jupiter.api.extension.ExtensionContext;

final class GlobalTestBeans
implements ExtensionContext.Store.CloseableResource {
    private static final System.Logger log = AppLog.getLogger((String)"io.avaje.inject");
    private final ReentrantLock lock = new ReentrantLock();
    private boolean started;
    private Beans globalBeans;

    GlobalTestBeans() {
    }

    Beans obtain(ExtensionContext context) {
        this.lock.lock();
        try {
            if (!this.started) {
                this.initialise(context);
                this.started = true;
            }
            Beans beans = this.globalBeans;
            return beans;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void initialise(ExtensionContext context) {
        this.globalBeans = GlobalInitialise.initialise(false);
        log.log(System.Logger.Level.TRACE, "register global test BeanScope with beans {0}", this.globalBeans);
        context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL).put((Object)InjectJunitExtension.class.getCanonicalName(), (Object)this);
    }

    public void close() {
        this.lock.lock();
        try {
            if (this.globalBeans != null) {
                log.log(System.Logger.Level.DEBUG, "Closing global test BeanScope");
                this.globalBeans.close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static final class Beans {
        private final Plugin.Scope plugin;
        private final BeanScope allBeans;
        private final BeanScope baseBeans;

        Beans(Plugin.Scope plugin, BeanScope allBeans, BeanScope baseBeans) {
            this.plugin = plugin;
            this.allBeans = allBeans;
            this.baseBeans = baseBeans;
        }

        void close() {
            if (this.plugin != null) {
                this.plugin.close();
            }
            if (this.allBeans != null) {
                this.allBeans.close();
            }
            if (this.baseBeans != null) {
                this.baseBeans.close();
            }
        }

        Plugin.Scope allPlugin() {
            return this.plugin;
        }

        BeanScope allBeans() {
            return this.allBeans;
        }

        BeanScope baseBeans() {
            return this.baseBeans;
        }

        Beans withBeans(TestBeans otherBeans) {
            return new Beans(otherBeans.plugin(), otherBeans.beanScope(), this.baseBeans);
        }

        public String toString() {
            return "All[" + String.valueOf(this.allBeans) + "] Test[" + String.valueOf(this.baseBeans) + "]";
        }
    }
}

