/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.standalone.server;

import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.util.PropertiesReader;
import io.atomix.manager.ResourceServer;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;

public class StandaloneServer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"AtomixServer").defaultHelp(true).description("Atomix server");
        parser.addArgument(new String[]{"address"}).required(true).help("The server address");
        parser.addArgument(new String[]{"-bootstrap"}).nargs("*").help("Bootstraps a new cluster");
        parser.addArgument(new String[]{"-join"}).nargs("*").help("Joins an existing cluster");
        parser.addArgument(new String[]{"-config"}).help("Atomix configuration file");
        Namespace ns = null;
        try {
            ns = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
        }
        String address = ns.getString("address");
        String config = ns.getString("config");
        Properties properties = PropertiesReader.load((String)config).properties();
        ResourceServer.Builder builder = ResourceServer.builder((Address)new Address(address), (Properties)properties);
        ResourceServer server = builder.build();
        List bootstrap = ns.getList("bootstrap");
        if (bootstrap != null) {
            List cluster = bootstrap.stream().map(Address::new).collect(Collectors.toList());
            server.bootstrap(cluster).join();
        } else {
            List join = ns.getList("join");
            if (join != null) {
                List cluster = join.stream().map(Address::new).collect(Collectors.toList());
                server.join(cluster).join();
            } else {
                System.err.println("Must configure either -bootstrap or -join");
            }
        }
        Class<StandaloneServer> clazz = StandaloneServer.class;
        synchronized (StandaloneServer.class) {
            while (server.isRunning()) {
                StandaloneServer.class.wait();
            }
            // ** MonitorExit[var9_10] (shouldn't be in output)
            return;
        }
    }
}

