/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource.internal;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.copycat.Query;
import io.atomix.resource.internal.ResourceOperation;

public final class ResourceQuery<T extends Query<U>, U>
extends ResourceOperation<T, U>
implements Query<U> {
    private Query.ConsistencyLevel consistency;

    public ResourceQuery() {
    }

    public ResourceQuery(T query, Query.ConsistencyLevel consistency) {
        super(query);
        this.consistency = consistency;
    }

    @Override
    public Query.ConsistencyLevel consistency() {
        Query.ConsistencyLevel consistency = ((Query)this.operation).consistency();
        return consistency != null ? consistency : this.consistency;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeByte(this.consistency.ordinal());
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.consistency = Query.ConsistencyLevel.values()[buffer.readByte()];
    }

    @Override
    public String toString() {
        return String.format("%s[query=%s, consistency=%s]", new Object[]{this.getClass().getSimpleName(), this.operation, this.consistency()});
    }
}

