/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource.internal;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.copycat.Operation;

public abstract class InstanceOperation<T extends Operation<U>, U>
implements Operation<U>,
CatalystSerializable {
    protected long resource;
    protected T operation;

    protected InstanceOperation() {
    }

    protected InstanceOperation(long resource, T operation) {
        this.resource = resource;
        this.operation = operation;
    }

    public long resource() {
        return this.resource;
    }

    public T operation() {
        return this.operation;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeLong(this.resource);
        serializer.writeObject(this.operation, buffer);
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.resource = buffer.readLong();
        this.operation = (Operation)serializer.readObject(buffer);
    }

    public String toString() {
        return String.format("%s[resource=%s, operation=%s]", this.getClass().getSimpleName(), this.resource, this.operation.getClass().getSimpleName());
    }
}

