/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource.internal;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.Serializer;

public final class InstanceEvent<T>
implements CatalystSerializable {
    private long resource;
    private T message;

    public InstanceEvent() {
    }

    public InstanceEvent(long resource, T message) {
        this.resource = resource;
        this.message = message;
    }

    public long resource() {
        return this.resource;
    }

    public T message() {
        return this.message;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeLong(this.resource);
        serializer.writeObject(this.message, buffer);
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.resource = buffer.readLong();
        this.message = serializer.readObject(buffer);
    }

    public String toString() {
        return String.format("%s[resource=%d, message=%s]", this.getClass().getSimpleName(), this.resource, this.message);
    }
}

