/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachine;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.resource.ResourceStateMachineExecutor;
import io.atomix.resource.internal.ResourceCommand;
import io.atomix.resource.internal.ResourceQuery;
import java.util.Properties;

public abstract class ResourceStateMachine
extends StateMachine
implements SessionListener {
    protected final Properties config;

    protected ResourceStateMachine(Properties config) {
        this.config = Assert.notNull(config, "config");
    }

    @Override
    public final void init(StateMachineExecutor executor) {
        executor.serializer().register(ResourceCommand.class, -50);
        executor.serializer().register(ResourceQuery.class, -51);
        executor.serializer().register(ResourceCommand.Config.class, -52);
        executor.serializer().register(ResourceCommand.Delete.class, -53);
        executor.register(ResourceCommand.Config.class, this::config);
        executor.register(ResourceCommand.Delete.class, this::delete);
        super.init(new ResourceStateMachineExecutor(executor));
    }

    @Override
    public void register(ServerSession session) {
    }

    @Override
    public void unregister(ServerSession session) {
    }

    @Override
    public void expire(ServerSession session) {
    }

    @Override
    public void close(ServerSession session) {
    }

    private Properties config(Commit<ResourceCommand.Config> commit) {
        try {
            Properties properties = this.config;
            return properties;
        }
        finally {
            commit.close();
        }
    }

    private void delete(Commit<ResourceCommand.Delete> commit) {
        try {
            this.delete();
        }
        finally {
            commit.close();
        }
    }

    public void delete() {
    }
}

