/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Listener;
import io.atomix.catalyst.util.Managed;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.resource.ResourceType;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public interface Resource<T extends Resource<T>>
extends Managed<T> {
    public ResourceType type();

    public Serializer serializer();

    public Config config();

    public Options options();

    public State state();

    public Listener<State> onStateChange(Consumer<State> var1);

    public ThreadContext context();

    @Override
    public CompletableFuture<T> open();

    @Override
    public CompletableFuture<Void> close();

    public CompletableFuture<Void> delete();

    public static enum State {
        CONNECTED,
        SUSPENDED,
        CLOSED;

    }

    public static class Options
    extends Properties {
        public Options() {
        }

        public Options(Properties defaults) {
            super(defaults);
        }
    }

    public static class Config
    extends Properties
    implements Serializable {
        public Config() {
        }

        public Config(Properties defaults) {
            for (String property : defaults.stringPropertyNames()) {
                this.setProperty(property, defaults.getProperty(property));
            }
        }
    }
}

