/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.Listener;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceType;
import io.atomix.resource.internal.ResourceCommand;
import io.atomix.resource.internal.ResourceQuery;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;

public abstract class AbstractResource<T extends Resource<T>>
implements Resource<T> {
    private final ResourceType type;
    protected final CopycatClient client;
    protected volatile Resource.Config config;
    protected final Resource.Options options;
    private volatile Resource.State state;
    private final Set<StateChangeListener> changeListeners = new CopyOnWriteArraySet<StateChangeListener>();

    protected AbstractResource(CopycatClient client, Properties options) {
        this(client, null, options);
    }

    protected AbstractResource(CopycatClient client, ResourceType type, Properties options) {
        this.client = Assert.notNull(client, "client");
        if (type == null) {
            type = new ResourceType(this.getClass());
        }
        this.type = type;
        client.serializer().register(ResourceCommand.class, -50);
        client.serializer().register(ResourceQuery.class, -51);
        client.serializer().register(ResourceCommand.Config.class, -52);
        client.serializer().register(ResourceCommand.Delete.class, -53);
        client.serializer().register(ResourceType.class, -54);
        this.config = new Resource.Config();
        this.options = new Resource.Options(Assert.notNull(options, "options"));
        client.onStateChange(this::onStateChange);
    }

    private void onStateChange(CopycatClient.State state) {
        this.state = Resource.State.valueOf(state.name());
        this.changeListeners.forEach(l -> l.accept(this.state));
    }

    @Override
    public ResourceType type() {
        return this.type;
    }

    @Override
    public Serializer serializer() {
        return this.client.serializer();
    }

    @Override
    public Resource.Config config() {
        return this.config;
    }

    @Override
    public Resource.Options options() {
        return this.options;
    }

    @Override
    public Resource.State state() {
        return this.state;
    }

    @Override
    public Listener<Resource.State> onStateChange(Consumer<Resource.State> callback) {
        return new StateChangeListener(Assert.notNull(callback, "callback"));
    }

    @Override
    public ThreadContext context() {
        return this.client.context();
    }

    protected <R> CompletableFuture<R> submit(Command<R> command) {
        return this.client.submit(new ResourceCommand(Assert.notNull(command, "command")));
    }

    protected <R> CompletableFuture<R> submit(Query<R> query) {
        return this.client.submit(new ResourceQuery(Assert.notNull(query, "query"), ReadConsistency.ATOMIC.level()));
    }

    protected <R> CompletableFuture<R> submit(Query<R> query, ReadConsistency consistency) {
        return this.client.submit(new ResourceQuery(Assert.notNull(query, "query"), consistency.level()));
    }

    @Override
    public CompletableFuture<T> open() {
        return ((CompletableFuture)this.client.connect().thenCompose(v -> this.client.submit(new ResourceCommand.Config()))).thenApply(config -> {
            this.config = new Resource.Config((Properties)config);
            return this;
        });
    }

    @Override
    public boolean isOpen() {
        return this.state != Resource.State.CLOSED;
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.client.close();
    }

    @Override
    public boolean isClosed() {
        return this.state == Resource.State.CLOSED;
    }

    @Override
    public CompletableFuture<Void> delete() {
        return this.client.submit(new ResourceCommand.Delete());
    }

    public int hashCode() {
        return 851 + this.client.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof AbstractResource && ((AbstractResource)object).client.session().id() == this.client.session().id();
    }

    public String toString() {
        return String.format("%s[id=%s]", this.getClass().getSimpleName(), this.client.session().id());
    }

    private class StateChangeListener
    implements Listener<Resource.State> {
        private final Consumer<Resource.State> callback;

        private StateChangeListener(Consumer<Resource.State> callback) {
            this.callback = callback;
            AbstractResource.this.changeListeners.add(this);
        }

        @Override
        public void accept(Resource.State state) {
            this.callback.accept(state);
        }

        @Override
        public void close() {
            AbstractResource.this.changeListeners.remove(this);
        }
    }
}

