/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager.options;

import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.ConfigurationException;
import io.atomix.catalyst.util.QualifiedProperties;
import io.atomix.copycat.server.storage.StorageLevel;
import io.atomix.manager.options.AtomixOptions;
import io.atomix.resource.ResourceType;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;

public class ServerOptions
extends AtomixOptions {
    public static final String TRANSPORT = "server.transport";
    public static final String ELECTION_TIMEOUT = "raft.electionTimeout";
    public static final String HEARTBEAT_INTERVAL = "raft.heartbeatInterval";
    public static final String SESSION_TIMEOUT = "raft.sessionTimeout";
    public static final String STORAGE_DIRECTORY = "storage.directory";
    public static final String STORAGE_LEVEL = "storage.level";
    public static final String MAX_SEGMENT_SIZE = "storage.maxSegmentSize";
    public static final String MAX_ENTRIES_PER_SEGMENT = "storage.maxEntriesPerSegment";
    public static final String RETAIN_STALE_SNAPSHOTS = "storage.compaction.retainSnapshots";
    public static final String COMPACTION_THREADS = "storage.compaction.threads";
    public static final String MINOR_COMPACTION_INTERVAL = "storage.compaction.minor";
    public static final String MAJOR_COMPACTION_INTERVAL = "storage.compaction.major";
    public static final String COMPACTION_THRESHOLD = "storage.compaction.threshold";
    private static final String DEFAULT_TRANSPORT = "io.atomix.catalyst.transport.NettyTransport";
    private static final Duration DEFAULT_ELECTION_TIMEOUT = Duration.ofMillis(500L);
    private static final Duration DEFAULT_HEARTBEAT_INTERVAL = Duration.ofMillis(250L);
    private static final Duration DEFAULT_SESSION_TIMEOUT = Duration.ofSeconds(5L);
    private static final File DEFAULT_STORAGE_DIRECTORY = new File(System.getProperty("user.dir"));
    private static final StorageLevel DEFAULT_STORAGE_LEVEL = StorageLevel.DISK;
    private static final int DEFAULT_MAX_SEGMENT_SIZE = 0x2000000;
    private static final int DEFAULT_MAX_ENTRIES_PER_SEGMENT = 0x100000;
    private static final int DEFAULT_MAX_SNAPSHOT_SIZE = 0x2000000;
    private static final boolean DEFAULT_RETAIN_STALE_SNAPSHOTS = false;
    private static final int DEFAULT_COMPACTION_THREADS = Runtime.getRuntime().availableProcessors() / 2;
    private static final Duration DEFAULT_MINOR_COMPACTION_INTERVAL = Duration.ofMinutes(1L);
    private static final Duration DEFAULT_MAJOR_COMPACTION_INTERVAL = Duration.ofHours(1L);
    private static final double DEFAULT_COMPACTION_THRESHOLD = 0.5;

    public ServerOptions(Properties properties) {
        super(properties);
    }

    public Transport transport() {
        String transportClass = this.reader.getString(TRANSPORT, DEFAULT_TRANSPORT);
        try {
            return (Transport)Class.forName(transportClass).getConstructor(Properties.class).newInstance(new QualifiedProperties(this.reader.properties(), TRANSPORT));
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("unknown transport class: " + transportClass, new Object[]{e});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigurationException("failed to instantiate transport", new Object[]{e});
        }
    }

    public Collection<ResourceType> resourceTypes() {
        return this.reader.getCollection("resource", resource -> new ResourceType(this.reader.getClass((String)resource)));
    }

    public Duration electionTimeout() {
        return this.reader.getDuration(ELECTION_TIMEOUT, DEFAULT_ELECTION_TIMEOUT);
    }

    public Duration heartbeatInterval() {
        return this.reader.getDuration(HEARTBEAT_INTERVAL, DEFAULT_HEARTBEAT_INTERVAL);
    }

    public Duration sessionTimeout() {
        return this.reader.getDuration(SESSION_TIMEOUT, DEFAULT_SESSION_TIMEOUT);
    }

    public File storageDirectory() {
        return this.reader.getFile(STORAGE_DIRECTORY, DEFAULT_STORAGE_DIRECTORY);
    }

    public StorageLevel storageLevel() {
        return this.reader.getEnum(STORAGE_LEVEL, StorageLevel.class, DEFAULT_STORAGE_LEVEL);
    }

    public int maxSegmentSize() {
        return this.reader.getInteger(MAX_SEGMENT_SIZE, 0x2000000);
    }

    public int maxEntriesPerSegment() {
        return this.reader.getInteger(MAX_ENTRIES_PER_SEGMENT, 0x100000);
    }

    public boolean retainStaleSnapshots() {
        return this.reader.getBoolean(RETAIN_STALE_SNAPSHOTS, false);
    }

    public int compactionThreads() {
        return this.reader.getInteger(COMPACTION_THREADS, DEFAULT_COMPACTION_THREADS);
    }

    public Duration minorCompactionInterval() {
        return this.reader.getDuration(MINOR_COMPACTION_INTERVAL, DEFAULT_MINOR_COMPACTION_INTERVAL);
    }

    public Duration majorCompactionInterval() {
        return this.reader.getDuration(MAJOR_COMPACTION_INTERVAL, DEFAULT_MAJOR_COMPACTION_INTERVAL);
    }

    public double compactionThreshold() {
        return this.reader.getDouble(COMPACTION_THRESHOLD, 0.5);
    }
}

