/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager.internal;

import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.Snapshottable;
import io.atomix.copycat.server.StateMachine;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import io.atomix.manager.internal.CloseResource;
import io.atomix.manager.internal.DeleteResource;
import io.atomix.manager.internal.GetResource;
import io.atomix.manager.internal.GetResourceIfExists;
import io.atomix.manager.internal.GetResourceKeys;
import io.atomix.manager.internal.ManagedResourceSession;
import io.atomix.manager.internal.ResourceExists;
import io.atomix.manager.internal.ResourceManagerCommitPool;
import io.atomix.manager.internal.ResourceManagerException;
import io.atomix.manager.internal.ResourceManagerStateMachineExecutor;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceStateMachine;
import io.atomix.resource.ResourceType;
import io.atomix.resource.internal.InstanceOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ResourceManagerState
extends StateMachine
implements SessionListener,
Snapshottable {
    private StateMachineExecutor executor;
    private final Map<String, Long> keys = new HashMap<String, Long>();
    private final Map<Long, ResourceHolder> resources = new HashMap<Long, ResourceHolder>();
    private final ResourceManagerCommitPool commits = new ResourceManagerCommitPool();

    @Override
    public void configure(StateMachineExecutor executor) {
        this.executor = executor;
        executor.register(InstanceOperation.class, this::operateResource);
        executor.register(GetResource.class, this::getResource);
        executor.register(GetResourceIfExists.class, this::getResourceIfExists);
        executor.register(CloseResource.class, this::closeResource);
        executor.register(DeleteResource.class, this::deleteResource);
        executor.register(ResourceExists.class, this::resourceExists);
        executor.register(GetResourceKeys.class, this::getResourceKeys);
    }

    @Override
    public void snapshot(SnapshotWriter writer) {
        ArrayList<ResourceHolder> resources = new ArrayList<ResourceHolder>(this.resources.values());
        Collections.sort(resources, (r1, r2) -> (int)(((ResourceHolder)r1).id - ((ResourceHolder)r2).id));
        for (ResourceHolder resource : resources) {
            if (!(resource.stateMachine instanceof Snapshottable)) continue;
            ((Snapshottable)((Object)resource.stateMachine)).snapshot(writer);
        }
    }

    @Override
    public void install(SnapshotReader reader) {
        ArrayList<ResourceHolder> resources = new ArrayList<ResourceHolder>(this.resources.values());
        Collections.sort(resources, (r1, r2) -> (int)(((ResourceHolder)r1).id - ((ResourceHolder)r2).id));
        for (ResourceHolder resource : resources) {
            if (!(resource.stateMachine instanceof Snapshottable)) continue;
            ((Snapshottable)((Object)resource.stateMachine)).install(reader);
        }
    }

    private Object operateResource(Commit<InstanceOperation> commit) {
        long resourceId = commit.operation().resource();
        ResourceHolder resource = this.resources.get(resourceId);
        if (resource == null) {
            commit.close();
            throw new ResourceManagerException("unknown resource: " + resourceId, new Object[0]);
        }
        SessionHolder sessionHolder = (SessionHolder)resource.sessions.get(commit.session().id());
        ManagedResourceSession session = sessionHolder != null ? sessionHolder.session : new ManagedResourceSession(resourceId, commit.session());
        return resource.executor.execute(this.commits.acquire(commit, session));
    }

    protected long getResource(Commit<? extends GetResource> commit) {
        String key = commit.operation().key();
        ResourceType type = commit.operation().type();
        Long resourceId = this.keys.get(key);
        if (resourceId == null) {
            resourceId = commit.index();
            this.keys.put(key, resourceId);
            try {
                ResourceStateMachine stateMachine = type.factory().newInstance().createStateMachine(new Resource.Config(commit.operation().config()));
                ResourceManagerStateMachineExecutor executor = new ResourceManagerStateMachineExecutor(resourceId, this.executor);
                ResourceHolder resourceHolder = new ResourceHolder(resourceId, key, type, commit, stateMachine, executor);
                this.resources.put(resourceId, resourceHolder);
                stateMachine.init(executor);
                ManagedResourceSession session = new ManagedResourceSession(resourceId, commit.session());
                SessionHolder holder = new SessionHolder(commit, session);
                resourceHolder.sessions.put(commit.session().id(), holder);
                stateMachine.register(session);
                return resourceId;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ResourceManagerException("failed to instantiate state machine", new Object[]{e});
            }
        }
        ResourceHolder resourceHolder = this.resources.get(resourceId);
        if (resourceHolder == null || !resourceHolder.type.equals(type)) {
            throw new ResourceManagerException("inconsistent resource type: " + commit.operation().type(), new Object[0]);
        }
        SessionHolder holder = (SessionHolder)resourceHolder.sessions.get(commit.session().id());
        if (holder == null) {
            ManagedResourceSession session = new ManagedResourceSession(resourceId, commit.session());
            holder = new SessionHolder(commit, session);
            resourceHolder.sessions.put(commit.session().id(), holder);
            resourceHolder.stateMachine.register(session);
            return resourceId;
        }
        commit.close();
        return holder.session.id();
    }

    private long getResourceIfExists(Commit<GetResourceIfExists> commit) {
        String key = commit.operation().key();
        Long resourceId = this.keys.get(key);
        if (resourceId != null) {
            return this.getResource(commit);
        }
        return 0L;
    }

    protected boolean resourceExists(Commit<ResourceExists> commit) {
        try {
            boolean bl = this.keys.containsKey(commit.operation().key());
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResource(Commit<CloseResource> commit) {
        block8: {
            try {
                long resourceId = commit.operation().resource();
                ResourceHolder resourceHolder = this.resources.get(resourceId);
                if (resourceHolder == null) {
                    throw new ResourceManagerException("unknown resource: " + resourceId, new Object[0]);
                }
                SessionHolder sessionHolder = (SessionHolder)resourceHolder.sessions.remove(commit.session().id());
                if (sessionHolder == null) break block8;
                try {
                    resourceHolder.stateMachine.unregister(sessionHolder.session);
                    resourceHolder.stateMachine.close(sessionHolder.session);
                }
                finally {
                    if (sessionHolder.commit != resourceHolder.commit) {
                        sessionHolder.commit.close();
                    }
                }
            }
            finally {
                commit.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deleteResource(Commit<DeleteResource> commit) {
        try {
            ResourceHolder resourceHolder = this.resources.remove(commit.operation().resource());
            if (resourceHolder == null) {
                throw new ResourceManagerException("unknown resource: " + commit.operation().resource(), new Object[0]);
            }
            try {
                resourceHolder.stateMachine.delete();
                resourceHolder.executor.close();
            }
            finally {
                resourceHolder.commit.close();
            }
            for (SessionHolder sessionHolder : resourceHolder.sessions.values()) {
                if (sessionHolder.commit == resourceHolder.commit) continue;
                sessionHolder.commit.close();
            }
            this.keys.remove(resourceHolder.key);
            boolean bl = true;
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected Set<String> getResourceKeys(Commit<GetResourceKeys> commit) {
        try {
            if (commit.operation().type() == 0) {
                HashSet<String> hashSet = new HashSet<String>(this.keys.keySet());
                return hashSet;
            }
            HashSet<String> hashSet = new HashSet<String>(this.resources.entrySet().stream().filter(e -> ((ResourceHolder)e.getValue()).type.id() == ((GetResourceKeys)commit.operation()).type()).map(e -> ((ResourceHolder)e.getValue()).key).collect(Collectors.toSet()));
            return hashSet;
        }
        finally {
            commit.close();
        }
    }

    @Override
    public void register(ServerSession session) {
    }

    @Override
    public void expire(ServerSession session) {
        for (ResourceHolder resource : this.resources.values()) {
            SessionHolder sessionHolder = (SessionHolder)resource.sessions.get(session.id());
            if (sessionHolder == null) continue;
            resource.stateMachine.expire(sessionHolder.session);
        }
    }

    @Override
    public void unregister(ServerSession session) {
        for (ResourceHolder resource : this.resources.values()) {
            SessionHolder sessionHolder = (SessionHolder)resource.sessions.get(session.id());
            if (sessionHolder == null) continue;
            resource.stateMachine.unregister(sessionHolder.session);
        }
    }

    @Override
    public void close(ServerSession session) {
        for (ResourceHolder resource : this.resources.values()) {
            SessionHolder sessionHolder = (SessionHolder)resource.sessions.remove(session.id());
            if (sessionHolder == null) continue;
            resource.stateMachine.close(sessionHolder.session);
            if (resource.commit == sessionHolder.commit) continue;
            sessionHolder.commit.close();
        }
    }

    private static class SessionHolder {
        private final Commit commit;
        private final ManagedResourceSession session;

        private SessionHolder(Commit commit, ManagedResourceSession session) {
            this.commit = commit;
            this.session = session;
        }
    }

    private static class ResourceHolder {
        private final long id;
        private final String key;
        private final ResourceType type;
        private final Commit<? extends GetResource> commit;
        private final ResourceStateMachine stateMachine;
        private final ResourceManagerStateMachineExecutor executor;
        private final Map<Long, SessionHolder> sessions = new HashMap<Long, SessionHolder>();

        private ResourceHolder(long id, String key, ResourceType type, Commit<? extends GetResource> commit, ResourceStateMachine stateMachine, ResourceManagerStateMachineExecutor executor) {
            this.id = id;
            this.key = key;
            this.type = type;
            this.commit = commit;
            this.stateMachine = stateMachine;
            this.executor = executor;
        }
    }
}

