/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager;

import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.manager.internal.ResourceManagerException;
import io.atomix.manager.internal.ResourceManagerState;
import io.atomix.manager.options.ServerOptions;
import io.atomix.manager.util.ResourceManagerTypeResolver;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceType;
import io.atomix.resource.internal.ResourceRegistry;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public final class ResourceServer {
    private final CopycatServer server;

    public static Builder builder(Address address) {
        return ResourceServer.builder(address, address);
    }

    public static Builder builder(Address clientAddress, Address serverAddress) {
        return new Builder(clientAddress, serverAddress);
    }

    public static Builder builder(Address address, Properties properties) {
        return ResourceServer.builder(address, address, properties);
    }

    public static Builder builder(Address clientAddress, Address serverAddress, Properties properties) {
        ServerOptions options = new ServerOptions(properties);
        return new Builder(clientAddress, serverAddress).withTransport(options.transport()).withStorage(Storage.builder().withStorageLevel(options.storageLevel()).withDirectory(options.storageDirectory()).withMaxSegmentSize(options.maxSegmentSize()).withMaxEntriesPerSegment(options.maxEntriesPerSegment()).withRetainStaleSnapshots(options.retainStaleSnapshots()).withCompactionThreads(options.compactionThreads()).withMinorCompactionInterval(options.minorCompactionInterval()).withMajorCompactionInterval(options.majorCompactionInterval()).withCompactionThreshold(options.compactionThreshold()).build()).withSerializer(options.serializer()).withResourceTypes(options.resourceTypes()).withElectionTimeout(options.electionTimeout()).withHeartbeatInterval(options.heartbeatInterval()).withSessionTimeout(options.sessionTimeout());
    }

    public ResourceServer(CopycatServer server) {
        this.server = Assert.notNull(server, "server");
    }

    public ThreadContext context() {
        return this.server.context();
    }

    public Serializer serializer() {
        return this.server.serializer();
    }

    public CopycatServer server() {
        return this.server;
    }

    public CompletableFuture<ResourceServer> bootstrap() {
        return this.server.bootstrap().thenApply(v -> this);
    }

    public CompletableFuture<ResourceServer> bootstrap(Address ... cluster) {
        return this.bootstrap(Arrays.asList(cluster));
    }

    public CompletableFuture<ResourceServer> bootstrap(Collection<Address> cluster) {
        return this.server.bootstrap(cluster).thenApply(v -> this);
    }

    public CompletableFuture<ResourceServer> join(Address ... cluster) {
        return this.join(Arrays.asList(cluster));
    }

    public CompletableFuture<ResourceServer> join(Collection<Address> cluster) {
        return this.server.join(cluster).thenApply(v -> this);
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public CompletableFuture<Void> shutdown() {
        return this.server.shutdown();
    }

    public CompletableFuture<Void> leave() {
        return this.server.leave();
    }

    public static class Builder
    implements io.atomix.catalyst.util.Builder<ResourceServer> {
        private static final String SERVER_NAME = "atomix";
        private final CopycatServer.Builder builder;
        private final ResourceRegistry registry = new ResourceRegistry();

        private Builder(Address clientAddress, Address serverAddress) {
            this.builder = CopycatServer.builder(clientAddress, serverAddress).withName(SERVER_NAME);
        }

        public Builder withTransport(Transport transport) {
            this.builder.withTransport(transport);
            return this;
        }

        public Builder withClientTransport(Transport transport) {
            this.builder.withClientTransport(transport);
            return this;
        }

        public Builder withServerTransport(Transport transport) {
            this.builder.withServerTransport(transport);
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.builder.withSerializer(serializer);
            return this;
        }

        public Builder withStorage(Storage storage) {
            this.builder.withStorage(storage);
            return this;
        }

        public Builder withElectionTimeout(Duration electionTimeout) {
            this.builder.withElectionTimeout(electionTimeout);
            return this;
        }

        public Builder withHeartbeatInterval(Duration heartbeatInterval) {
            this.builder.withHeartbeatInterval(heartbeatInterval);
            return this;
        }

        public Builder withSessionTimeout(Duration sessionTimeout) {
            this.builder.withSessionTimeout(sessionTimeout);
            return this;
        }

        public Builder withResourceTypes(Class<? extends Resource<?>> ... types) {
            return this.withResourceTypes(Arrays.asList(types).stream().map(ResourceType::new).collect(Collectors.toList()));
        }

        public Builder withResourceTypes(ResourceType ... types) {
            return this.withResourceTypes(Arrays.asList(types));
        }

        public Builder withResourceTypes(Collection<ResourceType> types) {
            types.forEach(this.registry::register);
            return this;
        }

        public Builder addResourceType(Class<? extends Resource<?>> type) {
            return this.addResourceType(new ResourceType(type));
        }

        public Builder addResourceType(ResourceType type) {
            this.registry.register(type);
            return this;
        }

        @Override
        public ResourceServer build() {
            CopycatServer server = this.builder.withStateMachine(ResourceManagerState::new).build();
            server.serializer().resolve(new ResourceManagerTypeResolver());
            for (ResourceType type : this.registry.types()) {
                try {
                    type.factory().newInstance().createSerializableTypeResolver().resolve(server.serializer().registry());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ResourceManagerException(e);
                }
            }
            return new ResourceServer(server);
        }
    }
}

