/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.util;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.FileBuffer;
import io.atomix.catalyst.buffer.MappedBuffer;
import io.atomix.catalyst.util.Assert;

public final class OffsetIndex
implements AutoCloseable {
    private static final long MAX_POSITION = (long)Math.pow(2.0, 32.0) - 1L;
    private static final int ENTRY_SIZE = 12;
    private static final int OFFSET_SIZE = 8;
    private final Buffer buffer;
    private boolean skipped;
    private int size;
    private long lastOffset = -1L;
    private long currentOffset = -1L;
    private long currentMatch = -1L;

    public static long size(int maxEntries) {
        return (long)maxEntries * 12L + 16L;
    }

    public OffsetIndex(Buffer buffer) {
        this.buffer = Assert.notNull(buffer, "buffer");
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    public synchronized void index(long offset, long position) {
        Assert.argNot(offset, this.lastOffset > -1L && offset <= this.lastOffset, "offset cannot be less than or equal to the last offset in the index", new Object[0]);
        Assert.argNot(position > MAX_POSITION, "position cannot be greater than " + MAX_POSITION, new Object[0]);
        this.buffer.writeLong(offset).writeUnsignedInt(position);
        ++this.size;
        if (offset > this.lastOffset + 1L) {
            this.skipped = true;
        }
        this.lastOffset = offset;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean contains(long offset) {
        return !this.skipped ? offset <= this.lastOffset : this.position(offset) != -1L;
    }

    public synchronized long position(long offset) {
        long relativeOffset = this.find(offset);
        return relativeOffset != -1L ? this.buffer.readUnsignedInt(relativeOffset * 12L + 8L) : -1L;
    }

    public synchronized long find(long offset) {
        if (this.size == 0) {
            return -1L;
        }
        if (!this.skipped && offset <= this.lastOffset) {
            return offset;
        }
        if (offset == this.currentOffset) {
            return this.currentMatch;
        }
        if (this.currentOffset != -1L && this.currentMatch + 1L < (long)this.size && this.buffer.readLong((this.currentMatch + 1L) * 12L) == offset) {
            this.currentOffset = offset;
            return ++this.currentMatch;
        }
        int lo = 0;
        int hi = this.size - 1;
        while (lo < hi) {
            int mid = lo + (hi - lo) / 2;
            long i = this.buffer.readLong(mid * 12);
            if (i == offset) {
                this.currentOffset = offset;
                this.currentMatch = mid;
                return mid;
            }
            if (lo == mid) {
                i = this.buffer.readLong(hi * 12);
                if (i == offset) {
                    this.currentOffset = offset;
                    this.currentMatch = hi;
                    return hi;
                }
                return -1L;
            }
            if (i < offset) {
                lo = mid;
                continue;
            }
            hi = mid - 1;
        }
        if (this.buffer.readLong(hi * 12) == offset) {
            this.currentOffset = offset;
            this.currentMatch = hi;
            return hi;
        }
        return -1L;
    }

    private long findAfter(long offset) {
        if (this.size == 0) {
            return -1L;
        }
        if (!this.skipped && offset <= this.lastOffset) {
            return offset;
        }
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            long i = this.buffer.readLong(mid * 12);
            if (i < offset) {
                low = mid + 1;
                continue;
            }
            if (i > offset) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low < high ? (long)(low + 1) : (long)(high + 1);
    }

    public long truncate(long offset) {
        long lastOffset;
        if (offset == this.lastOffset) {
            return -1L;
        }
        if (offset == -1L) {
            this.buffer.position(0L).zero();
            this.lastOffset = -1L;
            this.currentMatch = -1L;
            this.currentOffset = -1L;
            return 0L;
        }
        long nearestOffset = this.findAfter(offset + 1L);
        if (nearestOffset == -1L) {
            return -1L;
        }
        long nearestIndex = nearestOffset * 12L;
        for (long i = lastOffset = this.lastOffset(); i > offset; --i) {
            if (this.position(i) == -1L) continue;
            --this.size;
        }
        long position = this.buffer.readUnsignedInt(nearestIndex + 8L);
        this.buffer.position(nearestIndex).zero(nearestIndex);
        this.lastOffset = offset;
        this.currentMatch = -1L;
        this.currentOffset = -1L;
        return position;
    }

    public void flush() {
        this.buffer.flush();
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    public void delete() {
        if (this.buffer instanceof FileBuffer) {
            ((FileBuffer)this.buffer).delete();
        } else if (this.buffer instanceof MappedBuffer) {
            ((MappedBuffer)this.buffer).delete();
        }
    }
}

