/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.entry;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.ReferenceManager;
import io.atomix.copycat.server.storage.compaction.Compaction;
import io.atomix.copycat.server.storage.entry.Entry;
import io.atomix.copycat.server.storage.entry.SessionEntry;

public class UnregisterEntry
extends SessionEntry<UnregisterEntry> {
    private boolean expired;

    public UnregisterEntry() {
    }

    public UnregisterEntry(ReferenceManager<Entry<?>> referenceManager) {
        super(referenceManager);
    }

    @Override
    public Compaction.Mode getCompactionMode() {
        return Compaction.Mode.TOMBSTONE;
    }

    public UnregisterEntry setExpired(boolean expired) {
        this.expired = expired;
        return this;
    }

    public boolean isExpired() {
        return this.expired;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeBoolean(this.expired);
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.expired = buffer.readBoolean();
    }

    @Override
    public String toString() {
        return String.format("%s[index=%d, term=%d, session=%d, expired=%b, timestamp=%d]", this.getClass().getSimpleName(), this.getIndex(), this.getTerm(), this.getSession(), this.isExpired(), this.getTimestamp());
    }
}

