/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.ComposableFuture;
import io.atomix.catalyst.util.concurrent.Futures;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.error.InternalException;
import io.atomix.copycat.error.UnknownSessionException;
import io.atomix.copycat.server.Snapshottable;
import io.atomix.copycat.server.StateMachine;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.server.state.ServerCommit;
import io.atomix.copycat.server.state.ServerCommitPool;
import io.atomix.copycat.server.state.ServerContext;
import io.atomix.copycat.server.state.ServerSessionContext;
import io.atomix.copycat.server.state.ServerSessionManager;
import io.atomix.copycat.server.state.ServerStateMachineContext;
import io.atomix.copycat.server.state.ServerStateMachineExecutor;
import io.atomix.copycat.server.storage.Log;
import io.atomix.copycat.server.storage.entry.CommandEntry;
import io.atomix.copycat.server.storage.entry.ConfigurationEntry;
import io.atomix.copycat.server.storage.entry.ConnectEntry;
import io.atomix.copycat.server.storage.entry.Entry;
import io.atomix.copycat.server.storage.entry.InitializeEntry;
import io.atomix.copycat.server.storage.entry.KeepAliveEntry;
import io.atomix.copycat.server.storage.entry.OperationEntry;
import io.atomix.copycat.server.storage.entry.QueryEntry;
import io.atomix.copycat.server.storage.entry.RegisterEntry;
import io.atomix.copycat.server.storage.entry.UnregisterEntry;
import io.atomix.copycat.server.storage.snapshot.Snapshot;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServerStateMachine
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerStateMachine.class);
    private final StateMachine stateMachine;
    private final ServerContext state;
    private final Log log;
    private final ServerStateMachineExecutor executor;
    private final ServerCommitPool commits;
    private volatile long lastApplied;
    private long lastCompleted;
    private Snapshot pendingSnapshot;

    ServerStateMachine(StateMachine stateMachine, ServerContext state, ThreadContext executor) {
        this.stateMachine = Assert.notNull(stateMachine, "stateMachine");
        this.state = Assert.notNull(state, "state");
        this.log = state.getLog();
        this.executor = new ServerStateMachineExecutor(new ServerStateMachineContext(state.getConnections(), new ServerSessionManager(state)), executor);
        this.commits = new ServerCommitPool(this.log, this.executor.context().sessions());
        this.init();
    }

    private void init() {
        this.stateMachine.init(this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeSnapshot() {
        Snapshot currentSnapshot = this.state.getSnapshotStore().currentSnapshot();
        if (this.pendingSnapshot == null && this.stateMachine instanceof Snapshottable && (currentSnapshot == null || this.log.compactor().compactIndex() > currentSnapshot.index() && this.lastApplied > currentSnapshot.index())) {
            this.pendingSnapshot = this.state.getSnapshotStore().createSnapshot(this.lastApplied);
            LOGGER.info("{} - Taking snapshot {}", (Object)this.state.getCluster().member().address(), (Object)this.pendingSnapshot.index());
            Snapshot snapshot = this.pendingSnapshot;
            synchronized (snapshot) {
                try (SnapshotWriter writer = this.pendingSnapshot.writer();){
                    ((Snapshottable)((Object)this.stateMachine)).snapshot(writer);
                }
            }
        }
    }

    private void installSnapshot() {
        Snapshot currentSnapshot = this.state.getSnapshotStore().currentSnapshot();
        if (currentSnapshot != null && currentSnapshot.index() > this.log.compactor().snapshotIndex() && currentSnapshot.index() == this.lastApplied && this.stateMachine instanceof Snapshottable) {
            LOGGER.info("{} - Installing snapshot {}", (Object)this.state.getCluster().member().address(), (Object)currentSnapshot.index());
            this.executor.executor().execute(() -> {
                Snapshot snapshot2 = currentSnapshot;
                synchronized (snapshot2) {
                    try (SnapshotReader reader = currentSnapshot.reader();){
                        ((Snapshottable)((Object)this.stateMachine)).install(reader);
                    }
                }
            });
            this.log.compactor().snapshotIndex(currentSnapshot.index());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeSnapshot() {
        if (this.pendingSnapshot != null && this.lastCompleted >= this.pendingSnapshot.index()) {
            long snapshotIndex = this.pendingSnapshot.index();
            LOGGER.debug("{} - Completing snapshot {}", (Object)this.state.getCluster().member().address(), (Object)snapshotIndex);
            Snapshot snapshot = this.pendingSnapshot;
            synchronized (snapshot) {
                Snapshot currentSnapshot = this.state.getSnapshotStore().currentSnapshot();
                if (currentSnapshot == null || snapshotIndex > currentSnapshot.index()) {
                    this.pendingSnapshot.complete();
                } else {
                    LOGGER.debug("Discarding pending snapshot at index {} since the current snapshot is at index {}", (Object)this.pendingSnapshot.index(), (Object)currentSnapshot.index());
                }
                this.pendingSnapshot = null;
            }
            this.log.compactor().snapshotIndex(snapshotIndex);
            this.log.compactor().compact();
        }
    }

    ServerStateMachineExecutor executor() {
        return this.executor;
    }

    long getLastApplied() {
        return this.lastApplied;
    }

    private void setLastApplied(long lastApplied) {
        if (lastApplied > this.lastApplied) {
            Assert.arg(lastApplied == this.lastApplied + 1L, "lastApplied must be sequential", new Object[0]);
            this.lastApplied = lastApplied;
            for (ServerSessionContext session : this.executor.context().sessions().sessions.values()) {
                session.setLastApplied(lastApplied);
            }
            this.takeSnapshot();
            this.installSnapshot();
        } else {
            Assert.arg(lastApplied == this.lastApplied, "lastApplied cannot be decreased", new Object[0]);
        }
    }

    long getLastCompleted() {
        return this.lastCompleted > 0L ? this.lastCompleted : this.lastApplied;
    }

    private long calculateLastCompleted(long index) {
        long lastCompleted = index;
        for (ServerSessionContext session : this.executor.context().sessions().sessions.values()) {
            lastCompleted = Math.min(lastCompleted, session.getLastCompleted());
        }
        return lastCompleted;
    }

    private void setLastCompleted(long lastCompleted) {
        if (!this.log.isOpen()) {
            return;
        }
        this.lastCompleted = Math.max(this.lastCompleted, lastCompleted);
        this.log.compactor().minorIndex(this.lastCompleted);
        this.completeSnapshot();
    }

    public void applyAll(long index) {
        if (!this.log.isOpen()) {
            return;
        }
        long lastIndex = Math.min(index, this.log.lastIndex());
        if (lastIndex > this.lastApplied) {
            for (long i = this.lastApplied + 1L; i <= lastIndex; ++i) {
                Object entry = this.log.get(i);
                if (entry != null) {
                    LOGGER.debug("{} - Applying {}", (Object)this.state.getCluster().member().address(), entry);
                    this.apply((Entry)entry).whenComplete((result, error) -> entry.release());
                }
                this.setLastApplied(i);
            }
        }
    }

    /*
     * Loose catch block
     */
    public <T> CompletableFuture<T> apply(long index) {
        if (index > this.lastApplied + 1L) {
            this.applyAll(index - 1L);
        }
        try {
            CompletableFuture<Object> completableFuture;
            try (Object entry = this.log.get(index);){
                if (entry != null) {
                    CompletableFuture<T> completableFuture2 = this.apply((Entry)entry);
                    return completableFuture2;
                }
                completableFuture = CompletableFuture.completedFuture(null);
            }
            return completableFuture;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.setLastApplied(index);
        }
    }

    public <T> CompletableFuture<T> apply(Entry entry) {
        LOGGER.debug("{} - Applying {}", (Object)this.state.getCluster().member().address(), (Object)entry);
        if (entry instanceof QueryEntry) {
            return this.apply((QueryEntry)entry);
        }
        if (entry instanceof CommandEntry) {
            return this.apply((CommandEntry)entry);
        }
        if (entry instanceof RegisterEntry) {
            return this.apply((RegisterEntry)entry);
        }
        if (entry instanceof KeepAliveEntry) {
            return this.apply((KeepAliveEntry)entry);
        }
        if (entry instanceof UnregisterEntry) {
            return this.apply((UnregisterEntry)entry);
        }
        if (entry instanceof InitializeEntry) {
            return this.apply((InitializeEntry)entry);
        }
        if (entry instanceof ConnectEntry) {
            return this.apply((ConnectEntry)entry);
        }
        if (entry instanceof ConfigurationEntry) {
            return this.apply((ConfigurationEntry)entry);
        }
        return Futures.exceptionalFuture(new InternalException("unknown state machine operation", new Object[0]));
    }

    private CompletableFuture<Void> apply(ConfigurationEntry entry) {
        this.log.release(entry.getIndex());
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> apply(ConnectEntry entry) {
        ServerSessionContext session = this.executor().context().sessions().getSession(entry.getClient());
        if (session != null) {
            session.setConnectIndex(entry.getIndex());
            session.trust();
            session.setTimestamp(entry.getTimestamp());
            session.setKeepAliveIndex(entry.getIndex());
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Long> apply(RegisterEntry entry) {
        long timestamp = this.executor.timestamp(entry.getTimestamp());
        long sessionId = entry.getIndex();
        ServerSessionContext session = new ServerSessionContext(sessionId, entry.getClient(), this.log, this.executor.context(), entry.getTimeout());
        this.executor.context().sessions().registerSession(session);
        session.setTimestamp(timestamp);
        this.suspectSessions(0L, timestamp);
        ThreadContext context = ThreadContext.currentContextOrThrow();
        long index = entry.getIndex();
        ComposableFuture<Long> future = new ComposableFuture<Long>();
        this.executor.executor().execute(() -> this.registerSession(index, timestamp, session, future, context));
        return future;
    }

    private void registerSession(long index, long timestamp, ServerSessionContext session, CompletableFuture<Long> future, ThreadContext context) {
        if (!this.log.isOpen()) {
            context.executor().execute(() -> future.completeExceptionally(new IllegalStateException("log closed")));
            return;
        }
        this.executor.tick(index, timestamp);
        this.executor.init(index, Instant.ofEpochMilli(timestamp), ServerStateMachineContext.Type.COMMAND);
        for (SessionListener listener : this.executor.context().sessions().listeners) {
            listener.register(session);
        }
        session.open();
        long lastCompleted = this.calculateLastCompleted(index);
        this.executor.commit();
        context.executor().execute(() -> {
            this.setLastCompleted(lastCompleted);
            future.complete(index);
        });
    }

    private CompletableFuture<Void> apply(KeepAliveEntry entry) {
        CompletableFuture<Void> future;
        ServerSessionContext session = this.executor.context().sessions().getSession(entry.getSession());
        long timestamp = this.executor.timestamp(entry.getTimestamp());
        this.suspectSessions(entry.getSession(), timestamp);
        if (session == null) {
            this.log.release(entry.getIndex());
            future = Futures.exceptionalFuture(new UnknownSessionException("unknown session: " + entry.getSession(), new Object[0]));
        } else if (!session.state().active()) {
            this.log.release(entry.getIndex());
            future = Futures.exceptionalFuture(new UnknownSessionException("inactive session: " + entry.getSession(), new Object[0]));
        } else {
            ThreadContext context = ThreadContext.currentContextOrThrow();
            long index = entry.getIndex();
            session.trust();
            session.setTimestamp(timestamp);
            long commandSequence = entry.getCommandSequence();
            long eventIndex = entry.getEventIndex();
            future = new CompletableFuture();
            this.executor.executor().execute(() -> this.keepAliveSession(index, timestamp, commandSequence, eventIndex, session, future, context));
            session.setKeepAliveIndex(entry.getIndex()).setRequestSequence(commandSequence);
        }
        return future;
    }

    private void keepAliveSession(long index, long timestamp, long commandSequence, long eventIndex, ServerSessionContext session, CompletableFuture<Void> future, ThreadContext context) {
        if (!this.log.isOpen()) {
            context.executor().execute(() -> future.completeExceptionally(new IllegalStateException("log closed")));
            return;
        }
        if (!session.state().active()) {
            context.executor().execute(() -> future.completeExceptionally(new UnknownSessionException("inactive session: " + session.id(), new Object[0])));
            return;
        }
        this.executor.tick(index, timestamp);
        this.executor.init(index, Instant.ofEpochMilli(timestamp), ServerStateMachineContext.Type.COMMAND);
        session.clearResults(commandSequence).resendEvents(eventIndex);
        long lastCompleted = this.calculateLastCompleted(index);
        this.executor.commit();
        context.executor().execute(() -> {
            this.setLastCompleted(lastCompleted);
            future.complete(null);
        });
    }

    private CompletableFuture<Void> apply(UnregisterEntry entry) {
        CompletableFuture<Void> future;
        ServerSessionContext session = this.executor.context().sessions().getSession(entry.getSession());
        long timestamp = this.executor.timestamp(entry.getTimestamp());
        this.suspectSessions(entry.getSession(), timestamp);
        if (session == null) {
            this.log.release(entry.getIndex());
            future = Futures.exceptionalFuture(new UnknownSessionException("unknown session: " + entry.getSession(), new Object[0]));
        } else if (!session.state().active()) {
            this.log.release(entry.getIndex());
            future = Futures.exceptionalFuture(new UnknownSessionException("inactive session: " + entry.getSession(), new Object[0]));
        } else {
            ThreadContext context = ThreadContext.currentContextOrThrow();
            future = new CompletableFuture<Void>();
            long index = entry.getIndex();
            if (entry.isExpired()) {
                this.executor.executor().execute(() -> this.expireSession(index, timestamp, session, future, context));
            } else {
                this.executor.executor().execute(() -> this.closeSession(index, timestamp, session, future, context));
            }
        }
        return future;
    }

    private void expireSession(long index, long timestamp, ServerSessionContext session, CompletableFuture<Void> future, ThreadContext context) {
        if (!this.log.isOpen()) {
            context.executor().execute(() -> future.completeExceptionally(new IllegalStateException("log closed")));
            return;
        }
        if (!session.state().active()) {
            context.executor().execute(() -> future.completeExceptionally(new UnknownSessionException("inactive session: " + session.id(), new Object[0])));
            return;
        }
        this.executor.tick(index, timestamp);
        this.executor.init(index, Instant.ofEpochMilli(timestamp), ServerStateMachineContext.Type.COMMAND);
        session.expire(index);
        for (SessionListener listener : this.executor.context().sessions().listeners) {
            listener.expire(session);
            listener.close(session);
        }
        long lastCompleted = this.calculateLastCompleted(index);
        this.executor.commit();
        context.executor().execute(() -> {
            this.setLastCompleted(lastCompleted);
            future.complete(null);
        });
    }

    private void closeSession(long index, long timestamp, ServerSessionContext session, CompletableFuture<Void> future, ThreadContext context) {
        if (!this.log.isOpen()) {
            context.executor().execute(() -> future.completeExceptionally(new IllegalStateException("log closed")));
            return;
        }
        if (!session.state().active()) {
            context.executor().execute(() -> future.completeExceptionally(new UnknownSessionException("inactive session: " + session.id(), new Object[0])));
            return;
        }
        this.executor.tick(index, timestamp);
        this.executor.init(index, Instant.ofEpochMilli(timestamp), ServerStateMachineContext.Type.COMMAND);
        session.close(index);
        for (SessionListener listener : this.executor.context().sessions().listeners) {
            listener.unregister(session);
            listener.close(session);
        }
        long lastCompleted = this.calculateLastCompleted(index);
        this.executor.commit();
        context.executor().execute(() -> {
            this.setLastCompleted(lastCompleted);
            future.complete(null);
        });
    }

    private CompletableFuture<Result> apply(CommandEntry entry) {
        CompletableFuture<Result> future = new CompletableFuture<Result>();
        ThreadContext context = ThreadContext.currentContextOrThrow();
        ServerSessionContext session = this.executor.context().sessions().getSession(entry.getSession());
        if (session == null) {
            this.log.release(entry.getIndex());
            return Futures.exceptionalFuture(new UnknownSessionException("unknown session: " + entry.getSession(), new Object[0]));
        }
        if (!session.state().active()) {
            this.log.release(entry.getIndex());
            return Futures.exceptionalFuture(new UnknownSessionException("inactive session: " + entry.getSession(), new Object[0]));
        }
        if (entry.getSequence() > 0L && entry.getSequence() < session.nextCommandSequence()) {
            long sequence = entry.getSequence();
            this.executor.executor().execute(() -> this.sequenceCommand(sequence, session, future, context));
            return future;
        }
        long index = entry.getIndex();
        long sequence = entry.getSequence();
        long timestamp = this.executor.timestamp(entry.getTimestamp());
        ServerCommit commit = this.commits.acquire(entry, session, timestamp);
        this.executor.executor().execute(() -> this.executeCommand(index, sequence, timestamp, commit, session, future, context));
        this.setLastApplied(index);
        session.setTimestamp(timestamp).setCommandSequence(sequence);
        return future;
    }

    private void sequenceCommand(long sequence, ServerSessionContext session, CompletableFuture<Result> future, ThreadContext context) {
        if (!this.log.isOpen()) {
            context.executor().execute(() -> future.completeExceptionally(new IllegalStateException("log closed")));
            return;
        }
        Result result = session.getResult(sequence);
        if (result == null) {
            context.executor().execute(() -> future.completeExceptionally(new RuntimeException("missing result")));
        } else {
            context.executor().execute(() -> future.complete(result));
        }
    }

    private void executeCommand(long index, long sequence, long timestamp, ServerCommit commit, ServerSessionContext session, CompletableFuture<Result> future, ThreadContext context) {
        if (!this.log.isOpen()) {
            context.executor().execute(() -> future.completeExceptionally(new IllegalStateException("log closed")));
            return;
        }
        if (!session.state().active()) {
            context.executor().execute(() -> future.completeExceptionally(new UnknownSessionException("inactive session: " + session.id(), new Object[0])));
            return;
        }
        this.executor.tick(index, timestamp);
        this.executor.init(commit.index(), commit.time(), ServerStateMachineContext.Type.COMMAND);
        long eventIndex = session.getEventIndex();
        try {
            Object output = this.executor.executeOperation(commit);
            this.executor.commit();
            Result result = new Result(index, eventIndex, output);
            session.registerResult(sequence, result);
            context.executor().execute(() -> future.complete(result));
        }
        catch (Exception e) {
            Result result = new Result(index, eventIndex, e);
            session.registerResult(sequence, result);
            context.executor().execute(() -> future.complete(result));
        }
    }

    private CompletableFuture<Result> apply(QueryEntry entry) {
        ServerSessionContext session = this.executor.context().sessions().getSession(entry.getSession());
        if (session == null) {
            return Futures.exceptionalFuture(new UnknownSessionException("unknown session " + entry.getSession(), new Object[0]));
        }
        if (!session.state().active()) {
            return Futures.exceptionalFuture(new UnknownSessionException("inactive session: " + entry.getSession(), new Object[0]));
        }
        CompletableFuture<Result> future = new CompletableFuture<Result>();
        ThreadContext context = ThreadContext.currentContextOrThrow();
        ServerCommit commit = this.commits.acquire((OperationEntry)entry.setIndex(this.lastApplied), session, this.executor.timestamp());
        this.executor.executor().execute(() -> this.executeQuery(commit, session, future, context));
        return future;
    }

    private void executeQuery(ServerCommit commit, ServerSessionContext session, CompletableFuture<Result> future, ThreadContext context) {
        if (!this.log.isOpen()) {
            context.executor().execute(() -> future.completeExceptionally(new IllegalStateException("log closed")));
            return;
        }
        if (!session.state().active()) {
            context.executor().execute(() -> future.completeExceptionally(new UnknownSessionException("inactive session: " + session.id(), new Object[0])));
            return;
        }
        long index = commit.index();
        long eventIndex = session.getEventIndex();
        this.executor.init(index, commit.time(), ServerStateMachineContext.Type.QUERY);
        try {
            Object result = this.executor.executeOperation(commit);
            context.executor().execute(() -> future.complete(new Result(index, eventIndex, result)));
        }
        catch (Exception e) {
            context.executor().execute(() -> future.complete(new Result(index, eventIndex, e)));
        }
    }

    private CompletableFuture<Long> apply(InitializeEntry entry) {
        long timestamp = this.executor.timestamp(entry.getTimestamp());
        for (ServerSessionContext session : this.executor.context().sessions().sessions.values()) {
            session.setTimestamp(timestamp);
        }
        this.log.release(entry.getIndex());
        return Futures.completedFutureAsync(entry.getIndex(), ThreadContext.currentContextOrThrow().executor());
    }

    private void suspectSessions(long exclude, long timestamp) {
        for (ServerSessionContext session : this.executor.context().sessions().sessions.values()) {
            if (session.id() == exclude || timestamp - session.timeout() <= session.getTimestamp()) continue;
            session.suspect();
        }
    }

    @Override
    public void close() {
        this.executor.close();
    }

    static final class Result {
        final long index;
        final long eventIndex;
        final Object result;

        Result(long index, long eventIndex, Object result) {
            this.index = index;
            this.eventIndex = eventIndex;
            this.result = result;
        }
    }
}

