/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.Listener;
import io.atomix.catalyst.util.Listeners;
import io.atomix.copycat.protocol.PublishRequest;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.state.ServerStateMachine;
import io.atomix.copycat.server.state.ServerStateMachineContext;
import io.atomix.copycat.server.storage.Log;
import io.atomix.copycat.session.Event;
import io.atomix.copycat.session.Session;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServerSessionContext
implements ServerSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSessionContext.class);
    private final long id;
    private final UUID client;
    private final Log log;
    private final ServerStateMachineContext context;
    private boolean open;
    private volatile Session.State state = Session.State.OPEN;
    private final long timeout;
    private Connection connection;
    private Address address;
    private volatile long references;
    private long connectIndex;
    private long keepAliveIndex;
    private long requestSequence;
    private long commandSequence;
    private long lastApplied;
    private long commandLowWaterMark;
    private long eventIndex;
    private long completeIndex;
    private long closeIndex;
    private long timestamp;
    private final Queue<List<Runnable>> queriesPool = new ArrayDeque<List<Runnable>>();
    private final Map<Long, List<Runnable>> sequenceQueries = new HashMap<Long, List<Runnable>>();
    private final Map<Long, List<Runnable>> indexQueries = new HashMap<Long, List<Runnable>>();
    private final Map<Long, Runnable> commands = new HashMap<Long, Runnable>();
    private final Map<Long, ServerStateMachine.Result> results = new HashMap<Long, ServerStateMachine.Result>();
    private final Queue<EventHolder> events = new ArrayDeque<EventHolder>();
    private EventHolder event;
    private boolean unregistering;
    private final Listeners<Session.State> changeListeners = new Listeners();

    ServerSessionContext(long id, UUID client, Log log, ServerStateMachineContext context, long timeout) {
        this.id = id;
        this.client = Assert.notNull(client, "client");
        this.log = Assert.notNull(log, "log");
        this.eventIndex = id;
        this.completeIndex = id;
        this.lastApplied = id - 1L;
        this.context = context;
        this.timeout = timeout;
    }

    @Override
    public long id() {
        return this.id;
    }

    public UUID client() {
        return this.client;
    }

    void open() {
        this.open = true;
    }

    @Override
    public Session.State state() {
        return this.state;
    }

    private void setState(Session.State state) {
        if (this.state != state) {
            this.state = state;
            LOGGER.debug("{} - State changed: {}", (Object)this.id, (Object)state);
            this.changeListeners.forEach(l -> l.accept(state));
        }
    }

    @Override
    public Listener<Session.State> onStateChange(Consumer<Session.State> callback) {
        return this.changeListeners.add(callback);
    }

    void acquire() {
        ++this.references;
    }

    void release() {
        long references = --this.references;
        if (!this.state.active() && references == 0L) {
            this.context.sessions().unregisterSession(this.id);
            this.log.release(this.id);
            if (this.closeIndex > 0L) {
                this.log.release(this.closeIndex);
            }
        }
    }

    long references() {
        return this.references;
    }

    long timeout() {
        return this.timeout;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    ServerSessionContext setTimestamp(long timestamp) {
        this.timestamp = Math.max(this.timestamp, timestamp);
        return this;
    }

    long getConnectIndex() {
        return this.connectIndex;
    }

    ServerSessionContext setConnectIndex(long connectIndex) {
        long previousConnectIndex = this.connectIndex;
        this.connectIndex = connectIndex;
        if (previousConnectIndex > 0L) {
            this.log.release(previousConnectIndex);
        }
        return this;
    }

    long getKeepAliveIndex() {
        return this.keepAliveIndex;
    }

    ServerSessionContext setKeepAliveIndex(long keepAliveIndex) {
        long previousKeepAliveIndex = this.keepAliveIndex;
        this.keepAliveIndex = keepAliveIndex;
        if (previousKeepAliveIndex > 0L) {
            this.log.release(previousKeepAliveIndex);
        }
        return this;
    }

    long getRequestSequence() {
        return this.requestSequence;
    }

    long nextRequestSequence() {
        return this.requestSequence + 1L;
    }

    ServerSessionContext setRequestSequence(long request) {
        if (request > this.requestSequence) {
            this.requestSequence = request;
            Runnable command = this.commands.remove(this.nextRequestSequence());
            if (command != null) {
                command.run();
            }
        }
        return this;
    }

    long getCommandSequence() {
        return this.commandSequence;
    }

    long nextCommandSequence() {
        return this.commandSequence + 1L;
    }

    ServerSessionContext setCommandSequence(long sequence) {
        long i;
        for (i = this.commandSequence + 1L; i <= sequence; ++i) {
            this.commandSequence = i;
            List<Runnable> queries = this.sequenceQueries.remove(this.commandSequence);
            if (queries == null) continue;
            for (Runnable query : queries) {
                query.run();
            }
            queries.clear();
            this.queriesPool.add(queries);
        }
        if (sequence > this.requestSequence) {
            if (!this.commands.isEmpty()) {
                for (i = this.requestSequence + 1L; i <= this.requestSequence; ++i) {
                    this.requestSequence = i;
                    Runnable command = this.commands.remove(i);
                    if (command == null) continue;
                    command.run();
                }
            } else {
                this.requestSequence = sequence;
            }
        }
        return this;
    }

    long getLastApplied() {
        return this.lastApplied;
    }

    ServerSessionContext setLastApplied(long index) {
        for (long i = this.lastApplied + 1L; i <= index; ++i) {
            this.lastApplied = i;
            List<Runnable> queries = this.indexQueries.remove(this.lastApplied);
            if (queries == null) continue;
            for (Runnable query : queries) {
                query.run();
            }
            queries.clear();
            this.queriesPool.add(queries);
        }
        return this;
    }

    ServerSessionContext registerRequest(long sequence, Runnable runnable) {
        this.commands.put(sequence, runnable);
        return this;
    }

    ServerSessionContext registerSequenceQuery(long sequence, Runnable query) {
        List queries = this.sequenceQueries.computeIfAbsent(sequence, v -> {
            ArrayList q = this.queriesPool.poll();
            return q != null ? q : new ArrayList(128);
        });
        queries.add(query);
        return this;
    }

    ServerSessionContext registerIndexQuery(long index, Runnable query) {
        List queries = this.indexQueries.computeIfAbsent(index, v -> {
            ArrayList q = this.queriesPool.poll();
            return q != null ? q : new ArrayList(128);
        });
        queries.add(query);
        return this;
    }

    ServerSessionContext registerResult(long sequence, ServerStateMachine.Result result) {
        this.results.put(sequence, result);
        return this;
    }

    ServerSessionContext clearResults(long sequence) {
        if (sequence > this.commandLowWaterMark) {
            long i = this.commandLowWaterMark + 1L;
            while (i <= sequence) {
                this.results.remove(i);
                this.commandLowWaterMark = i++;
            }
        }
        return this;
    }

    ServerStateMachine.Result getResult(long sequence) {
        return this.results.get(sequence);
    }

    ServerSessionContext setConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    Connection getConnection() {
        return this.connection;
    }

    ServerSessionContext setAddress(Address address) {
        this.address = address;
        return this;
    }

    Address getAddress() {
        return this.address;
    }

    long getEventIndex() {
        return this.eventIndex;
    }

    @Override
    public Session publish(String event) {
        return this.publish(event, null);
    }

    @Override
    public Session publish(String event, Object message) {
        Assert.state(this.open, "cannot publish events during session registration", new Object[0]);
        Assert.stateNot(this.state == Session.State.CLOSED, "session is closed", new Object[0]);
        Assert.stateNot(this.state == Session.State.EXPIRED, "session is expired", new Object[0]);
        Assert.state(this.context.type() == ServerStateMachineContext.Type.COMMAND, "session events can only be published during command execution", new Object[0]);
        if (this.completeIndex > this.context.index()) {
            return this;
        }
        if (this.event == null || this.event.eventIndex != this.context.index()) {
            long previousIndex = this.eventIndex;
            this.eventIndex = this.context.index();
            this.event = new EventHolder(this.eventIndex, previousIndex);
        }
        this.event.events.add(new Event(event, message));
        return this;
    }

    void commit(long index) {
        if (this.event != null && this.event.eventIndex == index) {
            this.events.add(this.event);
            this.sendEvent(this.event);
        }
    }

    long getLastCompleted() {
        EventHolder event = this.events.peek();
        if (event != null && event.eventIndex > this.completeIndex) {
            return event.eventIndex - 1L;
        }
        return this.lastApplied;
    }

    private ServerSessionContext clearEvents(long index) {
        if (index > this.completeIndex) {
            EventHolder event = this.events.peek();
            while (event != null && event.eventIndex <= index) {
                this.events.remove();
                this.completeIndex = event.eventIndex;
                event = this.events.peek();
            }
            this.completeIndex = index;
        }
        return this;
    }

    ServerSessionContext resendEvents(long index) {
        this.clearEvents(index);
        for (EventHolder event : this.events) {
            this.sendEvent(event);
        }
        return this;
    }

    private void sendEvent(EventHolder event) {
        if (this.connection != null) {
            this.sendEvent(event, this.connection);
        }
    }

    private void sendEvent(EventHolder event, Connection connection) {
        PublishRequest request = ((PublishRequest.Builder)PublishRequest.builder().withSession(this.id())).withEventIndex(event.eventIndex).withPreviousIndex(Math.max(event.previousIndex, this.completeIndex)).withEvents(event.events).build();
        LOGGER.debug("{} - Sending {}", (Object)this.id, (Object)request);
        connection.send(request).whenComplete((response, error) -> {
            if (error == null) {
                LOGGER.debug("{} - Received {}", (Object)this.id, response);
                if (response.status() == Response.Status.OK) {
                    this.clearEvents(response.index());
                } else if (response.error() == null && response.index() > 0L) {
                    this.resendEvents(response.index());
                }
            }
        });
    }

    void suspect() {
        this.setState(Session.State.UNSTABLE);
    }

    void trust() {
        this.setState(Session.State.OPEN);
    }

    void unregister() {
        this.unregistering = true;
    }

    boolean isUnregistering() {
        return this.unregistering;
    }

    void expire(long index) {
        this.setState(Session.State.EXPIRED);
        this.cleanState(index);
    }

    void close(long index) {
        this.setState(Session.State.CLOSED);
        this.cleanState(index);
    }

    private void cleanState(long index) {
        if (this.keepAliveIndex > 0L) {
            this.log.release(this.keepAliveIndex);
        }
        this.context.sessions().unregisterSession(this.id);
        if (this.references == 0L) {
            this.log.release(this.id);
            this.log.release(index);
        } else {
            this.closeIndex = index;
        }
    }

    public int hashCode() {
        int hashCode = 23;
        hashCode = 37 * hashCode + (int)(this.id ^ this.id >>> 32);
        return hashCode;
    }

    public boolean equals(Object object) {
        return object instanceof Session && ((Session)object).id() == this.id;
    }

    public String toString() {
        return String.format("%s[id=%d]", this.getClass().getSimpleName(), this.id);
    }

    private static class EventHolder {
        private final long eventIndex;
        private final long previousIndex;
        private final List<Event<?>> events = new ArrayList(8);

        private EventHolder(long eventIndex, long previousIndex) {
            this.eventIndex = eventIndex;
            this.previousIndex = previousIndex;
        }
    }
}

