/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.state.ServerCommit;
import io.atomix.copycat.server.state.ServerSessionContext;
import io.atomix.copycat.server.state.ServerSessionManager;
import io.atomix.copycat.server.storage.Log;
import io.atomix.copycat.server.storage.entry.OperationEntry;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServerCommitPool
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerCommitPool.class);
    private final Log log;
    private final ServerSessionManager sessions;
    private final Queue<ServerCommit> pool = new ConcurrentLinkedQueue<ServerCommit>();

    public ServerCommitPool(Log log, ServerSessionManager sessions) {
        this.log = Assert.notNull(log, "log");
        this.sessions = Assert.notNull(sessions, "sessions");
    }

    public ServerCommit acquire(OperationEntry entry, ServerSessionContext session, long timestamp) {
        ServerCommit commit = this.pool.poll();
        if (commit == null) {
            commit = new ServerCommit(this, this.log);
        }
        commit.reset(entry, session, timestamp);
        return commit;
    }

    public void release(ServerCommit commit) {
        this.pool.add(commit);
    }

    public void warn(ServerCommit commit) {
        LOGGER.warn("Server commit " + commit + " was garbage collected!\nCommit log is dirty!");
    }

    @Override
    public void close() {
        this.pool.clear();
    }
}

