/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.util.concurrent.Scheduled;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.protocol.AppendRequest;
import io.atomix.copycat.server.protocol.AppendResponse;
import io.atomix.copycat.server.protocol.ConfigureRequest;
import io.atomix.copycat.server.protocol.ConfigureResponse;
import io.atomix.copycat.server.protocol.InstallRequest;
import io.atomix.copycat.server.protocol.InstallResponse;
import io.atomix.copycat.server.protocol.PollRequest;
import io.atomix.copycat.server.protocol.VoteRequest;
import io.atomix.copycat.server.protocol.VoteResponse;
import io.atomix.copycat.server.state.AbstractState;
import io.atomix.copycat.server.state.ActiveState;
import io.atomix.copycat.server.state.FollowerAppender;
import io.atomix.copycat.server.state.MemberState;
import io.atomix.copycat.server.state.ServerContext;
import io.atomix.copycat.server.state.ServerMember;
import io.atomix.copycat.server.storage.entry.Entry;
import io.atomix.copycat.server.util.Quorum;
import java.time.Duration;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

final class FollowerState
extends ActiveState {
    private final FollowerAppender appender;
    private final Random random = new Random();
    private Scheduled heartbeatTimer;

    public FollowerState(ServerContext context) {
        super(context);
        this.appender = new FollowerAppender(context);
    }

    @Override
    public CopycatServer.State type() {
        return CopycatServer.State.FOLLOWER;
    }

    @Override
    public synchronized CompletableFuture<AbstractState> open() {
        return ((CompletableFuture)super.open().thenRun(this::startHeartbeatTimeout)).thenApply(v -> this);
    }

    private void startHeartbeatTimeout() {
        this.LOGGER.debug("{} - Starting heartbeat timer", (Object)this.context.getCluster().member().address());
        this.resetHeartbeatTimeout();
    }

    private void resetHeartbeatTimeout() {
        this.context.checkThread();
        if (this.isClosed()) {
            return;
        }
        if (this.heartbeatTimer != null) {
            this.heartbeatTimer.cancel();
        }
        Duration delay = this.context.getElectionTimeout().plus(Duration.ofMillis(this.random.nextInt((int)this.context.getElectionTimeout().toMillis())));
        this.heartbeatTimer = this.context.getThreadContext().schedule(delay, () -> {
            this.heartbeatTimer = null;
            if (this.isOpen()) {
                this.context.setLeader(0);
                this.LOGGER.debug("{} - Heartbeat timed out in {}", (Object)this.context.getCluster().member().address(), (Object)delay);
                this.sendPollRequests();
            }
        });
    }

    private void sendPollRequests() {
        long lastTerm;
        Entry lastEntry;
        this.heartbeatTimer = this.context.getThreadContext().schedule(this.context.getElectionTimeout(), () -> {
            this.LOGGER.debug("{} - Failed to poll a majority of the cluster in {}", (Object)this.context.getCluster().member().address(), (Object)this.context.getElectionTimeout());
            this.resetHeartbeatTimeout();
        });
        AtomicBoolean complete = new AtomicBoolean();
        HashSet votingMembers = new HashSet(this.context.getClusterState().getActiveMemberStates().stream().map(MemberState::getMember).collect(Collectors.toList()));
        if (votingMembers.isEmpty()) {
            this.context.transition(CopycatServer.State.CANDIDATE);
            return;
        }
        Quorum quorum = new Quorum(this.context.getClusterState().getQuorum(), elected -> {
            complete.set(true);
            if (elected.booleanValue()) {
                this.context.transition(CopycatServer.State.CANDIDATE);
            } else {
                this.resetHeartbeatTimeout();
            }
        });
        long lastIndex = this.context.getLog().lastIndex();
        Entry entry = lastEntry = lastIndex > 0L ? (Entry)this.context.getLog().get(lastIndex) : null;
        if (lastEntry != null) {
            lastTerm = lastEntry.getTerm();
            lastEntry.close();
        } else {
            lastTerm = 0L;
        }
        this.LOGGER.info("{} - Polling members {}", (Object)this.context.getCluster().member().address(), (Object)votingMembers);
        for (ServerMember member : votingMembers) {
            this.LOGGER.debug("{} - Polling {} for next term {}", this.context.getCluster().member().address(), member, this.context.getTerm() + 1L);
            PollRequest request = PollRequest.builder().withTerm(this.context.getTerm()).withCandidate(this.context.getCluster().member().address().hashCode()).withLogIndex(lastIndex).withLogTerm(lastTerm).build();
            this.context.getConnections().getConnection(member.serverAddress()).thenAccept(connection -> connection.send(request).whenCompleteAsync((response, error) -> {
                this.context.checkThread();
                if (this.isOpen() && !complete.get()) {
                    if (error != null) {
                        this.LOGGER.warn("{} - {}", (Object)this.context.getCluster().member().address(), (Object)error.getMessage());
                        quorum.fail();
                    } else {
                        if (response.term() > this.context.getTerm()) {
                            this.context.setTerm(response.term());
                        }
                        if (!response.accepted()) {
                            this.LOGGER.debug("{} - Received rejected poll from {}", (Object)this.context.getCluster().member().address(), (Object)member);
                            quorum.fail();
                        } else if (response.term() != this.context.getTerm()) {
                            this.LOGGER.debug("{} - Received accepted poll for a different term from {}", (Object)this.context.getCluster().member().address(), (Object)member);
                            quorum.fail();
                        } else {
                            this.LOGGER.debug("{} - Received accepted poll from {}", (Object)this.context.getCluster().member().address(), (Object)member);
                            quorum.succeed();
                        }
                    }
                }
            }, this.context.getThreadContext().executor()));
        }
    }

    @Override
    protected CompletableFuture<InstallResponse> install(InstallRequest request) {
        CompletableFuture<InstallResponse> future = super.install(request);
        this.resetHeartbeatTimeout();
        return future;
    }

    @Override
    protected CompletableFuture<ConfigureResponse> configure(ConfigureRequest request) {
        CompletableFuture<ConfigureResponse> future = super.configure(request);
        this.resetHeartbeatTimeout();
        return future;
    }

    @Override
    public CompletableFuture<AppendResponse> append(AppendRequest request) {
        CompletableFuture<AppendResponse> future = super.append(request);
        this.resetHeartbeatTimeout();
        this.appender.appendEntries();
        return future;
    }

    @Override
    protected VoteResponse handleVote(VoteRequest request) {
        VoteResponse response = super.handleVote(request);
        if (response.voted()) {
            this.resetHeartbeatTimeout();
        }
        return response;
    }

    private void cancelHeartbeatTimeout() {
        if (this.heartbeatTimer != null) {
            this.LOGGER.debug("{} - Cancelling heartbeat timer", (Object)this.context.getCluster().member().address());
            this.heartbeatTimer.cancel();
        }
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return ((CompletableFuture)super.close().thenRun(this.appender::close)).thenRun(this::cancelHeartbeatTimeout);
    }
}

