/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.protocol.AppendRequest;
import io.atomix.copycat.server.protocol.AppendResponse;
import io.atomix.copycat.server.protocol.ConfigureRequest;
import io.atomix.copycat.server.protocol.ConfigureResponse;
import io.atomix.copycat.server.protocol.InstallRequest;
import io.atomix.copycat.server.protocol.InstallResponse;
import io.atomix.copycat.server.state.MemberState;
import io.atomix.copycat.server.state.ServerContext;
import io.atomix.copycat.server.state.ServerMember;
import io.atomix.copycat.server.storage.entry.Entry;
import io.atomix.copycat.server.storage.snapshot.Snapshot;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAppender
implements AutoCloseable {
    private static final int MAX_BATCH_SIZE = 32768;
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final ServerContext context;
    protected boolean open = true;

    protected AbstractAppender(ServerContext context) {
        this.context = Assert.notNull(context, "context");
    }

    protected abstract void appendEntries(MemberState var1);

    protected AppendRequest buildAppendRequest(MemberState member, long lastIndex) {
        if (this.context.getLog().isEmpty() || member.getNextIndex() > lastIndex || member.getFailureCount() > 0) {
            return this.buildAppendEmptyRequest(member);
        }
        return this.buildAppendEntriesRequest(member, lastIndex);
    }

    protected AppendRequest buildAppendEmptyRequest(MemberState member) {
        Entry prevEntry = this.getPrevEntry(member);
        ServerMember leader = this.context.getLeader();
        return AppendRequest.builder().withTerm(this.context.getTerm()).withLeader(leader != null ? leader.id() : 0).withLogIndex(prevEntry != null ? prevEntry.getIndex() : 0L).withLogTerm(prevEntry != null ? prevEntry.getTerm() : 0L).withEntries(Collections.EMPTY_LIST).withCommitIndex(this.context.getCommitIndex()).withGlobalIndex(this.context.getGlobalIndex()).build();
    }

    protected AppendRequest buildAppendEntriesRequest(MemberState member, long lastIndex) {
        Entry prevEntry = this.getPrevEntry(member);
        ServerMember leader = this.context.getLeader();
        AppendRequest.Builder builder = AppendRequest.builder().withTerm(this.context.getTerm()).withLeader(leader != null ? leader.id() : 0).withLogIndex(prevEntry != null ? prevEntry.getIndex() : 0L).withLogTerm(prevEntry != null ? prevEntry.getTerm() : 0L).withCommitIndex(this.context.getCommitIndex()).withGlobalIndex(this.context.getGlobalIndex());
        long index = prevEntry != null ? prevEntry.getIndex() + 1L : this.context.getLog().firstIndex();
        ArrayList entries = new ArrayList((int)Math.min(8L, lastIndex - index + 1L));
        int size = 0;
        for (long i = index; i <= lastIndex; ++i) {
            Object entry = this.context.getLog().get(i);
            if (entry == null) continue;
            if (!entries.isEmpty() && size + ((Entry)entry).size() > 32768) break;
            size += ((Entry)entry).size();
            entries.add(entry);
        }
        if (prevEntry != null) {
            prevEntry.release();
        }
        return builder.withEntries(entries).build();
    }

    protected Entry getPrevEntry(MemberState member) {
        for (long prevIndex = Math.min(member.getNextIndex() - 1L, this.context.getLog().lastIndex()); prevIndex > 0L; --prevIndex) {
            Object entry = this.context.getLog().get(prevIndex);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    protected void sendAppendRequest(MemberState member, AppendRequest request) {
        member.startAppend();
        this.LOGGER.debug("{} - Sent {} to {}", this.context.getCluster().member().address(), request, member.getMember().address());
        this.context.getConnections().getConnection(member.getMember().address()).whenComplete((connection, error) -> {
            this.context.checkThread();
            if (this.open) {
                if (error == null) {
                    this.sendAppendRequest((Connection)connection, member, request);
                } else {
                    member.completeAppend();
                    this.handleAppendRequestFailure(member, request, (Throwable)error);
                }
            }
        });
    }

    protected void sendAppendRequest(Connection connection, MemberState member, AppendRequest request) {
        long timestamp = System.nanoTime();
        connection.send(request).whenComplete((response, error) -> {
            this.context.checkThread();
            if (!request.entries().isEmpty()) {
                member.completeAppend(System.nanoTime() - timestamp);
            } else {
                member.completeAppend();
            }
            if (this.open) {
                if (error == null) {
                    this.LOGGER.debug("{} - Received {} from {}", this.context.getCluster().member().address(), response, member.getMember().address());
                    this.handleAppendResponse(member, request, (AppendResponse)response);
                } else {
                    this.handleAppendResponseFailure(member, request, (Throwable)error);
                }
            }
        });
        this.updateNextIndex(member, request);
        if (!request.entries().isEmpty() && this.hasMoreEntries(member)) {
            this.appendEntries(member);
        }
    }

    protected void handleAppendRequestFailure(MemberState member, AppendRequest request, Throwable error) {
        this.failAttempt(member, error);
    }

    protected void handleAppendResponseFailure(MemberState member, AppendRequest request, Throwable error) {
        this.failAttempt(member, error);
    }

    protected void handleAppendResponse(MemberState member, AppendRequest request, AppendResponse response) {
        if (response.status() == Response.Status.OK) {
            this.handleAppendResponseOk(member, request, response);
        } else {
            this.handleAppendResponseError(member, request, response);
        }
    }

    protected void handleAppendResponseOk(MemberState member, AppendRequest request, AppendResponse response) {
        this.succeedAttempt(member);
        if (response.succeeded()) {
            this.updateMatchIndex(member, response);
            if (request.logIndex() != response.logIndex() && this.hasMoreEntries(member)) {
                this.appendEntries(member);
            }
        } else if (response.term() > this.context.getTerm()) {
            this.context.setTerm(response.term()).setLeader(0);
            this.context.transition(CopycatServer.State.FOLLOWER);
        } else {
            this.resetMatchIndex(member, response);
            this.resetNextIndex(member);
            if (response.logIndex() != request.logIndex() && this.hasMoreEntries(member)) {
                this.appendEntries(member);
            }
        }
    }

    protected void handleAppendResponseError(MemberState member, AppendRequest request, AppendResponse response) {
        int failures = member.incrementFailureCount();
        if (failures <= 3 || failures % 100 == 0) {
            this.LOGGER.warn("{} - AppendRequest to {} failed. Reason: [{}]", this.context.getCluster().member().address(), member.getMember().serverAddress(), response.error() != null ? response.error() : "");
        }
    }

    protected void succeedAttempt(MemberState member) {
        member.resetFailureCount();
    }

    protected void failAttempt(MemberState member, Throwable error) {
        this.context.getConnections().resetConnection(member.getMember().serverAddress());
        int failures = member.incrementFailureCount();
        if (failures <= 3 || failures % 100 == 0) {
            this.LOGGER.warn("{} - AppendRequest to {} failed. Reason: {}", this.context.getCluster().member().address(), member.getMember().address(), error.getMessage());
        }
    }

    protected abstract boolean hasMoreEntries(MemberState var1);

    protected void updateMatchIndex(MemberState member, AppendResponse response) {
        member.setMatchIndex(response.logIndex());
    }

    protected void updateNextIndex(MemberState member, AppendRequest request) {
        if (!request.entries().isEmpty()) {
            member.setNextIndex(request.entries().get(request.entries().size() - 1).getIndex() + 1L);
        }
    }

    protected void resetMatchIndex(MemberState member, AppendResponse response) {
        member.setMatchIndex(response.logIndex());
        this.LOGGER.debug("{} - Reset match index for {} to {}", this.context.getCluster().member().address(), member, member.getMatchIndex());
    }

    protected void resetNextIndex(MemberState member) {
        if (member.getMatchIndex() != 0L) {
            member.setNextIndex(member.getMatchIndex() + 1L);
        } else {
            member.setNextIndex(this.context.getLog().firstIndex());
        }
        this.LOGGER.debug("{} - Reset next index for {} to {}", this.context.getCluster().member().address(), member, member.getNextIndex());
    }

    protected ConfigureRequest buildConfigureRequest(MemberState member) {
        ServerMember leader = this.context.getLeader();
        return ConfigureRequest.builder().withTerm(this.context.getTerm()).withLeader(leader != null ? leader.id() : 0).withIndex(this.context.getClusterState().getConfiguration().index()).withTime(this.context.getClusterState().getConfiguration().time()).withMembers(this.context.getClusterState().getConfiguration().members()).build();
    }

    protected void sendConfigureRequest(MemberState member, ConfigureRequest request) {
        member.startConfigure();
        this.context.getConnections().getConnection(member.getMember().serverAddress()).whenComplete((connection, error) -> {
            this.context.checkThread();
            if (this.open) {
                if (error == null) {
                    this.sendConfigureRequest((Connection)connection, member, request);
                } else {
                    member.completeConfigure();
                    this.handleConfigureRequestFailure(member, request, (Throwable)error);
                }
            }
        });
    }

    protected void sendConfigureRequest(Connection connection, MemberState member, ConfigureRequest request) {
        this.LOGGER.debug("{} - Sent {} to {}", this.context.getCluster().member().address(), request, member.getMember().serverAddress());
        connection.send(request).whenComplete((response, error) -> {
            this.context.checkThread();
            member.completeConfigure();
            if (this.open) {
                if (error == null) {
                    this.LOGGER.debug("{} - Received {} from {}", this.context.getCluster().member().address(), response, member.getMember().serverAddress());
                    this.handleConfigureResponse(member, request, (ConfigureResponse)response);
                } else {
                    this.LOGGER.warn("{} - Failed to configure {}", (Object)this.context.getCluster().member().address(), (Object)member.getMember().serverAddress());
                    this.handleConfigureResponseFailure(member, request, (Throwable)error);
                }
            }
        });
    }

    protected void handleConfigureRequestFailure(MemberState member, ConfigureRequest request, Throwable error) {
        this.failAttempt(member, error);
    }

    protected void handleConfigureResponseFailure(MemberState member, ConfigureRequest request, Throwable error) {
        this.failAttempt(member, error);
    }

    protected void handleConfigureResponse(MemberState member, ConfigureRequest request, ConfigureResponse response) {
        if (response.status() == Response.Status.OK) {
            this.handleConfigureResponseOk(member, request, response);
        } else {
            this.handleConfigureResponseError(member, request, response);
        }
    }

    protected void handleConfigureResponseOk(MemberState member, ConfigureRequest request, ConfigureResponse response) {
        this.succeedAttempt(member);
        member.setConfigTerm(request.term()).setConfigIndex(request.index());
        this.appendEntries(member);
    }

    protected void handleConfigureResponseError(MemberState member, ConfigureRequest request, ConfigureResponse response) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InstallRequest buildInstallRequest(MemberState member) {
        InstallRequest request;
        Snapshot snapshot = this.context.getSnapshotStore().currentSnapshot();
        if (member.getNextSnapshotIndex() != snapshot.index()) {
            member.setNextSnapshotIndex(snapshot.index()).setNextSnapshotOffset(0);
        }
        Snapshot snapshot2 = snapshot;
        synchronized (snapshot2) {
            try (SnapshotReader reader = snapshot.reader();){
                reader.skip(member.getNextSnapshotOffset() * 32768);
                byte[] data = new byte[Math.min(32768, (int)reader.remaining())];
                reader.read(data);
                ServerMember leader = this.context.getLeader();
                request = InstallRequest.builder().withTerm(this.context.getTerm()).withLeader(leader != null ? leader.id() : 0).withIndex(member.getNextSnapshotIndex()).withOffset(member.getNextSnapshotOffset()).withData(data).withComplete(!reader.hasRemaining()).build();
            }
        }
        return request;
    }

    protected void sendInstallRequest(MemberState member, InstallRequest request) {
        member.startInstall();
        this.context.getConnections().getConnection(member.getMember().serverAddress()).whenComplete((connection, error) -> {
            this.context.checkThread();
            if (this.open) {
                if (error == null) {
                    this.sendInstallRequest((Connection)connection, member, request);
                } else {
                    member.completeInstall();
                    this.handleInstallRequestFailure(member, request, (Throwable)error);
                }
            }
        });
    }

    protected void sendInstallRequest(Connection connection, MemberState member, InstallRequest request) {
        this.LOGGER.debug("{} - Sent {} to {}", this.context.getCluster().member().address(), request, member.getMember().serverAddress());
        connection.send(request).whenComplete((response, error) -> {
            this.context.checkThread();
            member.completeInstall();
            if (this.open) {
                if (error == null) {
                    this.LOGGER.debug("{} - Received {} from {}", this.context.getCluster().member().address(), response, member.getMember().serverAddress());
                    this.handleInstallResponse(member, request, (InstallResponse)response);
                } else {
                    this.LOGGER.warn("{} - Failed to install {}", (Object)this.context.getCluster().member().address(), (Object)member.getMember().serverAddress());
                    this.handleInstallResponseFailure(member, request, (Throwable)error);
                }
            }
        });
    }

    protected void handleInstallRequestFailure(MemberState member, InstallRequest request, Throwable error) {
        this.failAttempt(member, error);
    }

    protected void handleInstallResponseFailure(MemberState member, InstallRequest request, Throwable error) {
        member.setNextSnapshotIndex(0L).setNextSnapshotOffset(0);
        this.failAttempt(member, error);
    }

    protected void handleInstallResponse(MemberState member, InstallRequest request, InstallResponse response) {
        if (response.status() == Response.Status.OK) {
            this.handleInstallResponseOk(member, request, response);
        } else {
            this.handleInstallResponseError(member, request, response);
        }
    }

    protected void handleInstallResponseOk(MemberState member, InstallRequest request, InstallResponse response) {
        this.succeedAttempt(member);
        if (request.complete()) {
            member.setSnapshotIndex(request.index()).setNextSnapshotIndex(0L).setNextSnapshotOffset(0);
        } else {
            member.setNextSnapshotOffset(request.offset() + 1);
        }
        this.appendEntries(member);
    }

    protected void handleInstallResponseError(MemberState member, InstallRequest request, InstallResponse response) {
        this.LOGGER.warn("{} - Failed to install {}", (Object)this.context.getCluster().member().address(), (Object)member.getMember().serverAddress());
        member.setNextSnapshotIndex(0L).setNextSnapshotOffset(0);
    }

    @Override
    public void close() {
        this.open = false;
    }
}

